/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core;

import com.googlecode.flyway.core.clean.DbCleaner;
import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.dbsupport.DbSupportFactory;
import com.googlecode.flyway.core.metadatatable.MetaDataTable;
import com.googlecode.flyway.core.metadatatable.MetaDataTable085Upgrader;
import com.googlecode.flyway.core.metadatatable.MetaDataTableRow;
import com.googlecode.flyway.core.migration.DbMigrator;
import com.googlecode.flyway.core.migration.Migration;
import com.googlecode.flyway.core.migration.MigrationResolver;
import com.googlecode.flyway.core.migration.SchemaVersion;
import com.googlecode.flyway.core.migration.java.JavaMigrationResolver;
import com.googlecode.flyway.core.migration.sql.PlaceholderReplacer;
import com.googlecode.flyway.core.migration.sql.SqlMigrationResolver;
import com.googlecode.flyway.core.validation.DbValidator;
import com.googlecode.flyway.core.validation.ValidationErrorMode;
import com.googlecode.flyway.core.validation.ValidationMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class Flyway {
    private static final Log LOG = LogFactory.getLog(Flyway.class);
    private String basePackage = "db.migration";
    private String baseDir = "db/migration";
    private String encoding = "UTF-8";
    private String table = "schema_version";
    private Map<String, String> placeholders = new HashMap<String, String>();
    private String placeholderPrefix = "${";
    private String placeholderSuffix = "}";
    private String sqlMigrationPrefix = "V";
    private String sqlMigrationSuffix = ".sql";
    private ValidationMode validationMode = ValidationMode.NONE;
    private ValidationErrorMode validationErrorMode = ValidationErrorMode.FAIL;
    private JdbcTemplate jdbcTemplate;
    private TransactionTemplate transactionTemplate;
    private DbSupport dbSupport;
    private MetaDataTable metaDataTable;

    public void setValidationMode(ValidationMode validationMode) {
        this.validationMode = validationMode;
    }

    public void setValidationErrorMode(ValidationErrorMode validationErrorMode) {
        this.validationErrorMode = validationErrorMode;
    }

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Deprecated
    public void setSchemaMetaDataTable(String table) {
        this.table = table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public void setPlaceholders(Map<String, String> placeholders) {
        this.placeholders = placeholders;
    }

    public void setPlaceholderPrefix(String placeholderPrefix) {
        this.placeholderPrefix = placeholderPrefix;
    }

    public void setPlaceholderSuffix(String placeholderSuffix) {
        this.placeholderSuffix = placeholderSuffix;
    }

    public void setSqlMigrationPrefix(String sqlMigrationPrefix) {
        this.sqlMigrationPrefix = sqlMigrationPrefix;
    }

    public void setSqlMigrationSuffix(String sqlMigrationSuffix) {
        this.sqlMigrationSuffix = sqlMigrationSuffix;
    }

    public void setDataSource(DataSource dataSource) {
        DataSourceTransactionManager transactionManager = new DataSourceTransactionManager(dataSource);
        this.transactionTemplate = new TransactionTemplate((PlatformTransactionManager)transactionManager);
        this.jdbcTemplate = new JdbcTemplate(dataSource);
        this.dbSupport = DbSupportFactory.createDbSupport(this.jdbcTemplate);
        LOG.debug((Object)("Schema: " + this.dbSupport.getCurrentSchema(this.jdbcTemplate)));
        this.metaDataTable = new MetaDataTable(this.transactionTemplate, this.jdbcTemplate, this.dbSupport, this.table);
    }

    public int migrate() throws Exception {
        new MetaDataTable085Upgrader(this.transactionTemplate, this.jdbcTemplate, this.dbSupport, this.table, this.baseDir, this.encoding).upgrade();
        List<Migration> migrations = this.findAvailableMigrations();
        this.validate(migrations, this.validationMode);
        this.metaDataTable.createIfNotExists();
        DbMigrator dbMigrator = new DbMigrator(this.transactionTemplate, this.jdbcTemplate, this.dbSupport, this.metaDataTable);
        return dbMigrator.migrate(migrations);
    }

    private void validate(List<Migration> migrations, ValidationMode validationMode) {
        DbValidator dbValidator = new DbValidator(validationMode, this.metaDataTable, migrations);
        String validationError = dbValidator.validate();
        if (validationError != null) {
            String msg = "Flyway validate failed. Found differences between applied migrations and classpath migrations: " + validationError;
            if (ValidationErrorMode.CLEAN.equals((Object)this.validationErrorMode)) {
                LOG.warn((Object)(msg + " running clean and migrate again."));
                this.clean();
            } else {
                throw new IllegalStateException(msg);
            }
        }
    }

    private List<Migration> findAvailableMigrations() {
        PlaceholderReplacer placeholderReplacer = new PlaceholderReplacer(this.placeholders, this.placeholderPrefix, this.placeholderSuffix);
        ArrayList<MigrationResolver> migrationResolvers = new ArrayList<MigrationResolver>();
        migrationResolvers.add(new SqlMigrationResolver(this.baseDir, placeholderReplacer, this.encoding, this.sqlMigrationPrefix, this.sqlMigrationSuffix));
        migrationResolvers.add(new JavaMigrationResolver(this.basePackage));
        ArrayList<Migration> allMigrations = new ArrayList<Migration>();
        for (MigrationResolver migrationResolver : migrationResolvers) {
            allMigrations.addAll(migrationResolver.resolveMigrations());
        }
        if (allMigrations.isEmpty()) {
            LOG.warn((Object)"No migrations found!");
            return allMigrations;
        }
        Collections.sort(allMigrations);
        Collections.reverse(allMigrations);
        return allMigrations;
    }

    public void clean() {
        new DbCleaner(this.transactionTemplate, this.jdbcTemplate, this.dbSupport).clean();
    }

    public void validate() {
        new MetaDataTable085Upgrader(this.transactionTemplate, this.jdbcTemplate, this.dbSupport, this.table, this.baseDir, this.encoding).upgrade();
        List<Migration> migrations = this.findAvailableMigrations();
        this.validate(migrations, ValidationMode.ALL);
    }

    public MetaDataTableRow status() {
        new MetaDataTable085Upgrader(this.transactionTemplate, this.jdbcTemplate, this.dbSupport, this.table, this.baseDir, this.encoding).upgrade();
        return this.metaDataTable.latestAppliedMigration();
    }

    public List<MetaDataTableRow> history() {
        new MetaDataTable085Upgrader(this.transactionTemplate, this.jdbcTemplate, this.dbSupport, this.table, this.baseDir, this.encoding).upgrade();
        return this.metaDataTable.allAppliedMigrations();
    }

    public void init(SchemaVersion initialVersion) {
        new DbMigrator(this.transactionTemplate, this.jdbcTemplate, this.dbSupport, this.metaDataTable).init(initialVersion);
    }
}

