/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.dbsupport.mysql;

import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.dbsupport.mysql.MySQLSqlScript;
import com.googlecode.flyway.core.migration.sql.PlaceholderReplacer;
import com.googlecode.flyway.core.migration.sql.SqlScript;
import com.googlecode.flyway.core.migration.sql.SqlStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;

public class MySQLDbSupport
implements DbSupport {
    @Override
    public String getScriptLocation() {
        return "com/googlecode/flyway/core/dbsupport/mysql/";
    }

    @Override
    public String getCurrentUserFunction() {
        return "SUBSTRING_INDEX(USER(),'@',1)";
    }

    @Override
    public String getCurrentSchema(JdbcTemplate jdbcTemplate) {
        return (String)jdbcTemplate.execute(new ConnectionCallback(){

            public String doInConnection(Connection connection) throws SQLException, DataAccessException {
                return connection.getCatalog();
            }
        });
    }

    @Override
    public boolean supportsDatabase(String databaseProductName) {
        return "MySQL".equals(databaseProductName);
    }

    @Override
    public boolean tableExists(final JdbcTemplate jdbcTemplate, final String table) {
        return (Boolean)jdbcTemplate.execute(new ConnectionCallback(){

            public Boolean doInConnection(Connection connection) throws SQLException, DataAccessException {
                ResultSet resultSet = connection.getMetaData().getTables(MySQLDbSupport.this.getCurrentSchema(jdbcTemplate), null, table, null);
                return resultSet.next();
            }
        });
    }

    @Override
    public boolean columnExists(final JdbcTemplate jdbcTemplate, final String table, final String column) {
        return (Boolean)jdbcTemplate.execute(new ConnectionCallback(){

            public Boolean doInConnection(Connection connection) throws SQLException, DataAccessException {
                ResultSet resultSet = connection.getMetaData().getColumns(MySQLDbSupport.this.getCurrentSchema(jdbcTemplate), null, table, column);
                return resultSet.next();
            }
        });
    }

    @Override
    public boolean supportsDdlTransactions() {
        return false;
    }

    @Override
    public boolean supportsLocking() {
        return true;
    }

    @Override
    public SqlScript createSqlScript(String sqlScriptSource, PlaceholderReplacer placeholderReplacer) {
        return new MySQLSqlScript(sqlScriptSource, placeholderReplacer);
    }

    @Override
    public SqlScript createCleanScript(JdbcTemplate jdbcTemplate) {
        int lineNumber = 0;
        ArrayList<SqlStatement> sqlStatements = new ArrayList<SqlStatement>();
        lineNumber = this.cleanRoutines(jdbcTemplate, lineNumber, sqlStatements);
        lineNumber = this.cleanViews(jdbcTemplate, lineNumber, sqlStatements);
        this.cleanTables(jdbcTemplate, lineNumber, sqlStatements);
        return new SqlScript(sqlStatements);
    }

    private void cleanTables(JdbcTemplate jdbcTemplate, int lineNumber, List<SqlStatement> sqlStatements) {
        List tableNames = jdbcTemplate.queryForList("SELECT table_name FROM information_schema.tables WHERE table_schema=? AND table_type='BASE TABLE'", new Object[]{this.getCurrentSchema(jdbcTemplate)});
        sqlStatements.add(new SqlStatement(++lineNumber, "SET FOREIGN_KEY_CHECKS = 0"));
        for (Map row : tableNames) {
            String tableName = (String)row.get("table_name");
            sqlStatements.add(new SqlStatement(++lineNumber, "DROP TABLE " + tableName));
        }
        sqlStatements.add(new SqlStatement(++lineNumber, "SET FOREIGN_KEY_CHECKS = 1"));
    }

    private int cleanRoutines(JdbcTemplate jdbcTemplate, int lineNumber, List<SqlStatement> sqlStatements) {
        List routineNames = jdbcTemplate.queryForList("SELECT routine_name, routine_type FROM information_schema.routines WHERE routine_schema=?", new Object[]{this.getCurrentSchema(jdbcTemplate)});
        for (Map row : routineNames) {
            String routineName = (String)row.get("routine_name");
            String routineType = (String)row.get("routine_type");
            sqlStatements.add(new SqlStatement(++lineNumber, "DROP " + routineType + " " + routineName));
        }
        return lineNumber;
    }

    private int cleanViews(JdbcTemplate jdbcTemplate, int lineNumber, List<SqlStatement> sqlStatements) {
        List viewNames = jdbcTemplate.queryForList("SELECT table_name FROM information_schema.views WHERE table_schema=?", new Object[]{this.getCurrentSchema(jdbcTemplate)});
        for (Map row : viewNames) {
            String viewName = (String)row.get("table_name");
            sqlStatements.add(new SqlStatement(++lineNumber, "DROP VIEW " + viewName));
        }
        return lineNumber;
    }
}

