/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.dbsupport.oracle;

import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.dbsupport.oracle.OracleSqlScript;
import com.googlecode.flyway.core.migration.sql.PlaceholderReplacer;
import com.googlecode.flyway.core.migration.sql.SqlScript;
import com.googlecode.flyway.core.migration.sql.SqlStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class OracleDbSupport
implements DbSupport {
    private static final Log LOG = LogFactory.getLog(OracleDbSupport.class);

    @Override
    public String getScriptLocation() {
        return "com/googlecode/flyway/core/dbsupport/oracle/";
    }

    @Override
    public String getCurrentUserFunction() {
        return "USER";
    }

    @Override
    public String getCurrentSchema(JdbcTemplate jdbcTemplate) {
        return (String)jdbcTemplate.execute(new ConnectionCallback(){

            public String doInConnection(Connection connection) throws SQLException, DataAccessException {
                return connection.getMetaData().getUserName();
            }
        });
    }

    @Override
    public boolean supportsDatabase(String databaseProductName) {
        return "Oracle".equals(databaseProductName);
    }

    @Override
    public boolean tableExists(final JdbcTemplate jdbcTemplate, final String table) {
        return (Boolean)jdbcTemplate.execute(new ConnectionCallback(){

            public Boolean doInConnection(Connection connection) throws SQLException, DataAccessException {
                ResultSet resultSet = connection.getMetaData().getTables(null, OracleDbSupport.this.getCurrentSchema(jdbcTemplate), table.toUpperCase(), null);
                return resultSet.next();
            }
        });
    }

    @Override
    public boolean columnExists(final JdbcTemplate jdbcTemplate, final String table, final String column) {
        return (Boolean)jdbcTemplate.execute(new ConnectionCallback(){

            public Boolean doInConnection(Connection connection) throws SQLException, DataAccessException {
                ResultSet resultSet = connection.getMetaData().getColumns(null, OracleDbSupport.this.getCurrentSchema(jdbcTemplate), table.toUpperCase(), column.toUpperCase());
                return resultSet.next();
            }
        });
    }

    @Override
    public boolean supportsDdlTransactions() {
        return false;
    }

    @Override
    public boolean supportsLocking() {
        return true;
    }

    @Override
    public SqlScript createSqlScript(String sqlScriptSource, PlaceholderReplacer placeholderReplacer) {
        return new OracleSqlScript(sqlScriptSource, placeholderReplacer);
    }

    @Override
    public SqlScript createCleanScript(JdbcTemplate jdbcTemplate) {
        ArrayList<String> allDropStatements = new ArrayList<String>();
        allDropStatements.addAll(this.generateDropStatementsForObjectType(jdbcTemplate, "SEQUENCE", ""));
        allDropStatements.addAll(this.generateDropStatementsForObjectType(jdbcTemplate, "FUNCTION", ""));
        allDropStatements.addAll(this.generateDropStatementsForObjectType(jdbcTemplate, "MATERIALIZED VIEW", ""));
        allDropStatements.addAll(this.generateDropStatementsForObjectType(jdbcTemplate, "PACKAGE", ""));
        allDropStatements.addAll(this.generateDropStatementsForObjectType(jdbcTemplate, "PROCEDURE", ""));
        allDropStatements.addAll(this.generateDropStatementsForObjectType(jdbcTemplate, "SYNONYM", ""));
        allDropStatements.addAll(this.generateDropStatementsForObjectType(jdbcTemplate, "VIEW", ""));
        allDropStatements.addAll(this.generateDropStatementsForObjectType(jdbcTemplate, "TABLE", "CASCADE CONSTRAINTS PURGE"));
        allDropStatements.addAll(this.generateDropStatementsForObjectType(jdbcTemplate, "TYPE", ""));
        allDropStatements.addAll(this.generateDropStatementsForSpatialExtensions(jdbcTemplate));
        ArrayList<SqlStatement> sqlStatements = new ArrayList<SqlStatement>();
        int count = 0;
        for (String dropStatement : allDropStatements) {
            sqlStatements.add(new SqlStatement(++count, dropStatement));
        }
        return new SqlScript(sqlStatements);
    }

    private List<String> generateDropStatementsForObjectType(JdbcTemplate jdbcTemplate, String objectType, final String extraArguments) {
        return jdbcTemplate.query("SELECT object_type, object_name FROM user_objects WHERE object_type = ?", new Object[]{objectType}, new RowMapper(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                return "DROP " + rs.getString("OBJECT_TYPE") + " " + rs.getString("OBJECT_NAME") + " " + extraArguments;
            }
        });
    }

    private List<String> generateDropStatementsForSpatialExtensions(JdbcTemplate jdbcTemplate) {
        ArrayList<String> statements = new ArrayList<String>();
        if (this.spatialExtensionsAvailable(jdbcTemplate)) {
            String user = this.getCurrentSchema(jdbcTemplate);
            statements.add("DELETE FROM mdsys.user_sdo_geom_metadata");
            statements.add("DELETE FROM mdsys.sdo_index_metadata_table WHERE sdo_index_owner = '" + user + "'");
        } else {
            LOG.debug((Object)"Oracle Spatial Extensions are not available. No cleaning of MDSYS tables and views.");
        }
        return statements;
    }

    private boolean spatialExtensionsAvailable(JdbcTemplate jdbcTemplate) {
        return jdbcTemplate.queryForInt("SELECT COUNT(*) FROM all_tables WHERE owner = 'MDSYS' AND table_name = 'SDO_INDEX_METADATA_TABLE'") > 0;
    }
}

