/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.migration;

import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.metadatatable.MetaDataTable;
import com.googlecode.flyway.core.metadatatable.MetaDataTableRow;
import com.googlecode.flyway.core.migration.Migration;
import com.googlecode.flyway.core.migration.MigrationState;
import com.googlecode.flyway.core.migration.SchemaVersion;
import com.googlecode.flyway.core.migration.init.InitMigration;
import com.googlecode.flyway.core.util.ExceptionUtils;
import com.googlecode.flyway.core.util.TimeFormat;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.StopWatch;

public class DbMigrator {
    private static final Log LOG = LogFactory.getLog(DbMigrator.class);
    private final SchemaVersion targetVersion = SchemaVersion.LATEST;
    private final DbSupport dbSupport;
    private final MetaDataTable metaDataTable;
    private final TransactionTemplate transactionTemplate;
    private final JdbcTemplate jdbcTemplate;

    public DbMigrator(TransactionTemplate transactionTemplate, JdbcTemplate jdbcTemplate, DbSupport dbSupport, MetaDataTable metaDataTable) {
        this.transactionTemplate = transactionTemplate;
        this.jdbcTemplate = jdbcTemplate;
        this.dbSupport = dbSupport;
        this.metaDataTable = metaDataTable;
    }

    public void init(SchemaVersion schemaVersion) {
        if (this.metaDataTable.hasRows()) {
            throw new IllegalStateException("Schema already initialized. Current Version: " + this.metaDataTable.latestAppliedMigration().getVersion());
        }
        this.metaDataTable.createIfNotExists();
        InitMigration initialMigration = new InitMigration(schemaVersion);
        final MetaDataTableRow metaDataTableRow = new MetaDataTableRow(initialMigration);
        metaDataTableRow.update(0, MigrationState.SUCCESS);
        this.transactionTemplate.execute(new TransactionCallback(){

            public Void doInTransaction(TransactionStatus status) {
                DbMigrator.this.metaDataTable.insert(metaDataTableRow);
                return null;
            }
        });
        LOG.info((Object)("Schema initialized with version: " + schemaVersion));
    }

    public int migrate(final List<Migration> migrations) throws Exception {
        MetaDataTableRow metaDataTableRow;
        if (migrations.isEmpty()) {
            LOG.info((Object)"No migrations found");
            return 0;
        }
        int migrationSuccessCount = 0;
        while ((metaDataTableRow = (MetaDataTableRow)this.transactionTemplate.execute(new TransactionCallback(){

            public MetaDataTableRow doInTransaction(TransactionStatus status) {
                SchemaVersion currentSchemaVersion;
                DbMigrator.this.metaDataTable.lock();
                MetaDataTableRow latestAppliedMigration = DbMigrator.this.metaDataTable.latestAppliedMigration();
                if (latestAppliedMigration == null) {
                    currentSchemaVersion = SchemaVersion.EMPTY;
                } else {
                    latestAppliedMigration.assertNotFailed();
                    currentSchemaVersion = latestAppliedMigration.getVersion();
                }
                LOG.info((Object)("Current schema version: " + currentSchemaVersion));
                Migration migration = DbMigrator.this.getNextMigration(migrations, currentSchemaVersion);
                if (migration == null) {
                    return null;
                }
                return DbMigrator.this.applyMigration(migration, DbMigrator.this.transactionTemplate, DbMigrator.this.jdbcTemplate, DbMigrator.this.dbSupport);
            }
        })) != null) {
            metaDataTableRow.assertNotFailed();
            ++migrationSuccessCount;
        }
        if (migrationSuccessCount == 0) {
            LOG.info((Object)"Schema is up to date. No migration necessary.");
        } else if (migrationSuccessCount == 1) {
            LOG.info((Object)"Migration completed. Successfully applied 1 migration.");
        } else {
            LOG.info((Object)("Migration completed. Successfully applied " + migrationSuccessCount + " migrations."));
        }
        return migrationSuccessCount;
    }

    public final MetaDataTableRow applyMigration(final Migration migration, final TransactionTemplate transactionTemplate, final JdbcTemplate jdbcTemplate, final DbSupport dbSupport) {
        MetaDataTableRow metaDataTableRow = new MetaDataTableRow(migration);
        LOG.info((Object)("Migrating to version " + migration.getVersion()));
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        MigrationRunnable migrationRunnable = new MigrationRunnable(){

            @Override
            public void run() {
                try {
                    transactionTemplate.execute(new TransactionCallback(){

                        public Void doInTransaction(TransactionStatus status) {
                            migration.migrate(jdbcTemplate, dbSupport);
                            return null;
                        }
                    });
                    this.state = MigrationState.SUCCESS;
                }
                catch (Exception e) {
                    LOG.error((Object)e.toString());
                    Throwable rootCause = ExceptionUtils.getRootCause(e);
                    if (rootCause != null) {
                        LOG.error((Object)rootCause.toString());
                    }
                    this.state = MigrationState.FAILED;
                }
            }
        };
        Thread migrationThread = new Thread((Runnable)migrationRunnable, "Flyway Migration");
        migrationThread.start();
        try {
            migrationThread.join();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        stopWatch.stop();
        int executionTime = (int)stopWatch.getLastTaskTimeMillis();
        if (MigrationState.FAILED.equals((Object)migrationRunnable.state) && dbSupport.supportsDdlTransactions()) {
            throw new IllegalStateException("Migration failed! Changes rolled back. Aborting!");
        }
        LOG.info((Object)String.format("Finished migrating to version %s (execution time %s)", migration.getVersion(), TimeFormat.format(executionTime)));
        metaDataTableRow.update(executionTime, migrationRunnable.state);
        this.metaDataTable.insert(metaDataTableRow);
        return metaDataTableRow;
    }

    private Migration getNextMigration(List<Migration> allMigrations, SchemaVersion currentVersion) {
        SchemaVersion newestMigrationVersion = allMigrations.get(0).getVersion();
        if (newestMigrationVersion.compareTo(currentVersion) < 0) {
            LOG.warn((Object)("Database version (" + currentVersion.getVersion() + ") is newer than the latest migration (" + newestMigrationVersion + ") !"));
            return null;
        }
        Migration nextMigration = null;
        for (Migration migration : allMigrations) {
            if (migration.getVersion().compareTo(currentVersion) > 0 && migration.getVersion().compareTo(this.targetVersion) <= 0) {
                nextMigration = migration;
                continue;
            }
            return nextMigration;
        }
        return nextMigration;
    }

    private static abstract class MigrationRunnable
    implements Runnable {
        protected MigrationState state;

        private MigrationRunnable() {
        }
    }
}

