/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.migration.java;

import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.migration.BaseMigration;
import com.googlecode.flyway.core.migration.MigrationType;
import com.googlecode.flyway.core.migration.SchemaVersion;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.ClassUtils;

public abstract class BaseJavaMigration
extends BaseMigration {
    protected BaseJavaMigration() {
        this.initVersionFromClassName();
        this.initScriptName();
    }

    protected BaseJavaMigration(String version, String description) {
        this.schemaVersion = new SchemaVersion(version, description);
        this.initScriptName();
    }

    private void initScriptName() {
        this.script = this.getClass().getName();
        if (this.script.length() > 200) {
            this.script = this.script.substring(this.script.length() - 200);
        }
    }

    private void initVersionFromClassName() {
        String nameWithoutV = ClassUtils.getShortName(this.getClass()).substring(1);
        this.initVersion(nameWithoutV);
    }

    @Override
    public MigrationType getMigrationType() {
        return MigrationType.JAVA;
    }

    @Override
    public final void migrate(JdbcTemplate jdbcTemplate, DbSupport dbSupport) throws IllegalStateException {
        try {
            this.doMigrateInTransaction(jdbcTemplate);
        }
        catch (Exception e) {
            throw new IllegalStateException("Migration failed !", e);
        }
    }

    protected abstract void doMigrateInTransaction(JdbcTemplate var1) throws Exception;
}

