/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.validation;

import com.googlecode.flyway.core.metadatatable.MetaDataTable;
import com.googlecode.flyway.core.metadatatable.MetaDataTableRow;
import com.googlecode.flyway.core.migration.Migration;
import com.googlecode.flyway.core.migration.SchemaVersion;
import com.googlecode.flyway.core.util.TimeFormat;
import com.googlecode.flyway.core.validation.ValidationMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StopWatch;

public class DbValidator {
    private static final Log LOG = LogFactory.getLog(DbValidator.class);
    private final ValidationMode validationMode;
    private final MetaDataTable metaDataTable;
    private final List<Migration> migrations;

    public DbValidator(ValidationMode validationMode, MetaDataTable metaDataTable, List<Migration> migrations) {
        this.validationMode = validationMode;
        this.metaDataTable = metaDataTable;
        this.migrations = new ArrayList<Migration>(migrations);
        Collections.reverse(this.migrations);
    }

    public String validate() {
        if (ValidationMode.NONE.equals((Object)this.validationMode)) {
            return null;
        }
        LOG.debug((Object)String.format("Validating (mode %s) migrations ...", new Object[]{this.validationMode}));
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        List<MetaDataTableRow> appliedMigrations = this.metaDataTable.allAppliedMigrations();
        if (appliedMigrations.isEmpty()) {
            LOG.info((Object)"No migrations applied yet. No validation necessary.");
            return null;
        }
        if (appliedMigrations.size() > this.migrations.size()) {
            ArrayList<SchemaVersion> schemaVersions = new ArrayList<SchemaVersion>();
            for (MetaDataTableRow metaDataTableRow : appliedMigrations) {
                schemaVersions.add(metaDataTableRow.getVersion());
            }
            for (Migration migration : this.migrations) {
                schemaVersions.remove(migration.getVersion());
            }
            StringBuilder stringBuilder = new StringBuilder();
            boolean first = true;
            for (SchemaVersion schemaVersion : schemaVersions) {
                if (!first) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(schemaVersion.getVersion());
                first = false;
            }
            return String.format("more applied migrations than classpath migrations: DB=%s, Classpath=%s, missing migrations=(%s)", appliedMigrations.size(), this.migrations.size(), stringBuilder.toString());
        }
        for (int i = 0; i < appliedMigrations.size(); ++i) {
            Integer classpathChecksum;
            MetaDataTableRow appliedMigration = appliedMigrations.get(i);
            Migration classpathMigration = this.migrations.get(i);
            if (!appliedMigration.getVersion().equals(classpathMigration.getVersion())) {
                return String.format("Version mismatch for migration %s: DB=%s, Classpath=%s", appliedMigration.getScript(), appliedMigration.getVersion().getVersion(), classpathMigration.getVersion().getVersion());
            }
            if (!appliedMigration.getMigrationType().equals((Object)classpathMigration.getMigrationType())) {
                return String.format("Migration Type mismatch for migration %s: DB=%s, Classpath=%s", new Object[]{appliedMigration.getScript(), appliedMigration.getMigrationType(), classpathMigration.getMigrationType()});
            }
            Integer appliedChecksum = appliedMigration.getChecksum();
            if (ObjectUtils.nullSafeEquals((Object)appliedChecksum, (Object)(classpathChecksum = classpathMigration.getChecksum()))) continue;
            return String.format("Checksum mismatch for migration %s: DB=%s, Classpath=%s", appliedMigration.getScript(), appliedChecksum, classpathMigration.getChecksum());
        }
        stopWatch.stop();
        if (appliedMigrations.size() == 1) {
            LOG.info((Object)String.format("Validated 1 migration (mode: %s) (execution time %s)", new Object[]{this.validationMode, TimeFormat.format(stopWatch.getTotalTimeMillis())}));
        } else {
            LOG.info((Object)String.format("Validated %d migrations (mode: %s) (execution time %s)", new Object[]{appliedMigrations.size(), this.validationMode, TimeFormat.format(stopWatch.getTotalTimeMillis())}));
        }
        return null;
    }
}

