/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.migration;

import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.exception.FlywayException;
import com.googlecode.flyway.core.metadatatable.MetaDataTable;
import com.googlecode.flyway.core.metadatatable.MetaDataTableRow;
import com.googlecode.flyway.core.migration.Migration;
import com.googlecode.flyway.core.migration.MigrationException;
import com.googlecode.flyway.core.migration.MigrationState;
import com.googlecode.flyway.core.migration.SchemaVersion;
import com.googlecode.flyway.core.util.ExceptionUtils;
import com.googlecode.flyway.core.util.TimeFormat;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.StopWatch;

public class DbMigrator {
    private static final Log LOG = LogFactory.getLog(DbMigrator.class);
    private final SchemaVersion target;
    private final DbSupport dbSupport;
    private final MetaDataTable metaDataTable;
    private final TransactionTemplate transactionTemplate;
    private final JdbcTemplate jdbcTemplate;
    private final boolean ignoreFailedFutureMigration;

    public DbMigrator(TransactionTemplate transactionTemplate, JdbcTemplate jdbcTemplate, DbSupport dbSupport, MetaDataTable metaDataTable, SchemaVersion target, boolean ignoreFailedFutureMigration) {
        this.transactionTemplate = transactionTemplate;
        this.jdbcTemplate = jdbcTemplate;
        this.dbSupport = dbSupport;
        this.metaDataTable = metaDataTable;
        this.target = target;
        this.ignoreFailedFutureMigration = ignoreFailedFutureMigration;
    }

    public int migrate(List<Migration> migrations) throws FlywayException {
        if (migrations.isEmpty()) {
            LOG.info((Object)"No migrations found");
            return 0;
        }
        int migrationSuccessCount = 0;
        try {
            boolean firstRun;
            MetaDataTableRow metaDataTableRow;
            while ((metaDataTableRow = (MetaDataTableRow)this.transactionTemplate.execute(new TransactionCallback(firstRun = migrationSuccessCount == 0, migrations){
                final /* synthetic */ boolean val$firstRun;
                final /* synthetic */ List val$migrations;
                {
                    this.val$firstRun = bl;
                    this.val$migrations = list;
                }

                public MetaDataTableRow doInTransaction(TransactionStatus status) {
                    MigrationState currentSchemaState;
                    SchemaVersion latestAvailableMigrationVersion;
                    boolean isFutureMigration;
                    DbMigrator.this.metaDataTable.lock();
                    SchemaVersion currentSchemaVersion = DbMigrator.this.metaDataTable.getCurrentSchemaVersion();
                    if (this.val$firstRun) {
                        LOG.info((Object)("Current schema version: " + currentSchemaVersion));
                    }
                    boolean bl = isFutureMigration = (latestAvailableMigrationVersion = ((Migration)this.val$migrations.get(0)).getVersion()).compareTo(currentSchemaVersion) < 0;
                    if (isFutureMigration) {
                        LOG.warn((Object)("Database version (" + currentSchemaVersion + ") is newer than the latest available migration (" + latestAvailableMigrationVersion + ") !"));
                    }
                    if ((currentSchemaState = DbMigrator.this.metaDataTable.getCurrentSchemaState()) == MigrationState.FAILED) {
                        if (isFutureMigration && DbMigrator.this.ignoreFailedFutureMigration) {
                            LOG.warn((Object)("Detected failed migration to version " + currentSchemaVersion + " !"));
                        } else {
                            throw new MigrationException(currentSchemaVersion, false);
                        }
                    }
                    if (isFutureMigration) {
                        return null;
                    }
                    Migration migration = DbMigrator.this.getNextMigration(this.val$migrations, currentSchemaVersion);
                    if (migration == null) {
                        return null;
                    }
                    return DbMigrator.this.applyMigration(migration);
                }
            })) != null) {
                if (MigrationState.FAILED == metaDataTableRow.getState()) {
                    throw new MigrationException(metaDataTableRow.getVersion(), false);
                }
                ++migrationSuccessCount;
            }
        }
        catch (TransactionException e) {
            throw new FlywayException("Migration failed !", e);
        }
        this.logSummary(migrationSuccessCount);
        return migrationSuccessCount;
    }

    private void logSummary(int migrationSuccessCount) {
        if (migrationSuccessCount == 0) {
            LOG.info((Object)"Schema is up to date. No migration necessary.");
        } else if (migrationSuccessCount == 1) {
            LOG.info((Object)"Migration completed. Successfully applied 1 migration.");
        } else {
            LOG.info((Object)("Migration completed. Successfully applied " + migrationSuccessCount + " migrations."));
        }
    }

    public final MetaDataTableRow applyMigration(final Migration migration) throws MigrationException {
        MetaDataTableRow metaDataTableRow = new MetaDataTableRow(migration);
        LOG.info((Object)("Migrating to version " + migration.getVersion()));
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        MigrationRunnable migrationRunnable = new MigrationRunnable(){

            @Override
            public void run() {
                try {
                    DbMigrator.this.transactionTemplate.execute(new TransactionCallback(){

                        public Void doInTransaction(TransactionStatus status) {
                            migration.migrate(DbMigrator.this.jdbcTemplate, DbMigrator.this.dbSupport);
                            return null;
                        }
                    });
                    this.state = MigrationState.SUCCESS;
                }
                catch (Exception e) {
                    LOG.error((Object)e.toString());
                    Throwable rootCause = ExceptionUtils.getRootCause(e);
                    if (rootCause != null) {
                        LOG.error((Object)rootCause.toString());
                    }
                    this.state = MigrationState.FAILED;
                }
            }
        };
        Thread migrationThread = new Thread((Runnable)migrationRunnable, "Flyway Migration");
        migrationThread.start();
        try {
            migrationThread.join();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        stopWatch.stop();
        int executionTime = (int)stopWatch.getLastTaskTimeMillis();
        if (MigrationState.FAILED.equals((Object)migrationRunnable.state) && this.dbSupport.supportsDdlTransactions()) {
            throw new MigrationException(migration.getVersion(), true);
        }
        LOG.debug((Object)String.format("Finished migrating to version %s (execution time %s)", migration.getVersion(), TimeFormat.format(executionTime)));
        metaDataTableRow.update(executionTime, migrationRunnable.state);
        this.metaDataTable.insert(metaDataTableRow);
        return metaDataTableRow;
    }

    private Migration getNextMigration(List<Migration> allMigrations, SchemaVersion currentVersion) {
        if (this.target.compareTo(currentVersion) < 0) {
            LOG.warn((Object)("Database version (" + currentVersion + ") is newer than the target version (" + this.target + ") !"));
            return null;
        }
        Migration nextMigration = null;
        for (Migration migration : allMigrations) {
            if (migration.getVersion().compareTo(currentVersion) <= 0) break;
            nextMigration = migration;
        }
        if (nextMigration == null) {
            return null;
        }
        if (this.target.compareTo(nextMigration.getVersion()) < 0) {
            return null;
        }
        return nextMigration;
    }

    private static abstract class MigrationRunnable
    implements Runnable {
        protected MigrationState state;

        private MigrationRunnable() {
        }
    }
}

