/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.migration.sql;

import com.googlecode.flyway.core.migration.sql.PlaceholderReplacer;
import com.googlecode.flyway.core.migration.sql.SqlStatement;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.ObjectUtils;

public class SqlScript {
    private static final Log LOG = LogFactory.getLog(SqlScript.class);
    private static final String DEFAULT_STATEMENT_DELIMITER = ";";
    private final List<SqlStatement> sqlStatements;

    public SqlScript(String sqlScriptSource, PlaceholderReplacer placeholderReplacer) {
        this.sqlStatements = this.parse(sqlScriptSource, placeholderReplacer);
    }

    public SqlScript(List<SqlStatement> sqlStatements) {
        this.sqlStatements = sqlStatements;
    }

    protected SqlScript() {
        this.sqlStatements = null;
    }

    public List<SqlStatement> getSqlStatements() {
        return this.sqlStatements;
    }

    public void execute(JdbcTemplate jdbcTemplate) {
        for (SqlStatement sqlStatement : this.sqlStatements) {
            sqlStatement.execute(jdbcTemplate);
        }
    }

    private List<SqlStatement> parse(String sqlScriptSource, PlaceholderReplacer placeholderReplacer) {
        StringReader reader = new StringReader(sqlScriptSource);
        List<String> rawLines = this.readLines(reader);
        List<String> trimmedLines = this.trimLines(rawLines);
        List<String> noCommentLines = this.stripSqlComments(trimmedLines);
        List<String> noPlaceholderLines = this.replacePlaceholders(noCommentLines, placeholderReplacer);
        return this.linesToStatements(noPlaceholderLines);
    }

    List<SqlStatement> linesToStatements(List<String> lines) {
        ArrayList<SqlStatement> statements = new ArrayList<SqlStatement>();
        int statementLineNumber = 0;
        String statementSql = "";
        String delimiter = DEFAULT_STATEMENT_DELIMITER;
        for (int lineNumber = 1; lineNumber <= lines.size(); ++lineNumber) {
            String line = lines.get(lineNumber - 1);
            if (line.isEmpty()) continue;
            if (statementSql.isEmpty()) {
                statementLineNumber = lineNumber;
            } else {
                statementSql = statementSql + "\n";
            }
            statementSql = statementSql + line;
            String statementSqlWithoutLineBreaks = statementSql.replaceAll("\n", " ");
            String oldDelimiter = delimiter;
            delimiter = this.changeDelimiterIfNecessary(statementSqlWithoutLineBreaks, line, delimiter);
            if (!ObjectUtils.nullSafeEquals((Object)delimiter, (Object)oldDelimiter) && this.isDelimiterChangeExplicit()) {
                statementSql = "";
                continue;
            }
            if (delimiter == null || !line.endsWith(delimiter)) continue;
            String noDelimiterStatementSql = SqlScript.stripDelimiter(statementSql, delimiter);
            statements.add(new SqlStatement(statementLineNumber, noDelimiterStatementSql));
            LOG.debug((Object)("Found statement at line " + statementLineNumber + ": " + statementSql));
            if (!this.isDelimiterChangeExplicit()) {
                delimiter = DEFAULT_STATEMENT_DELIMITER;
            }
            statementSql = "";
        }
        if (!statementSql.isEmpty()) {
            statements.add(new SqlStatement(statementLineNumber, statementSql));
        }
        return statements;
    }

    protected String changeDelimiterIfNecessary(String statement, String line, String delimiter) {
        return delimiter;
    }

    protected boolean isDelimiterChangeExplicit() {
        return false;
    }

    private static String stripDelimiter(String sql, String delimiter) {
        return sql.substring(0, sql.length() - delimiter.length());
    }

    List<String> stripSqlComments(List<String> lines) {
        ArrayList<String> noCommentLines = new ArrayList<String>(lines.size());
        boolean inMultilineComment = false;
        for (String line : lines) {
            String trimmedLine = line.trim();
            if (!this.isCommentDirective(trimmedLine)) {
                if (trimmedLine.startsWith("--")) {
                    noCommentLines.add("");
                    continue;
                }
                if (trimmedLine.startsWith("/*")) {
                    inMultilineComment = true;
                }
                if (inMultilineComment) {
                    if (trimmedLine.endsWith("*/")) {
                        inMultilineComment = false;
                    }
                    noCommentLines.add("");
                    continue;
                }
            }
            noCommentLines.add(trimmedLine);
        }
        return noCommentLines;
    }

    protected boolean isCommentDirective(String line) {
        return false;
    }

    private List<String> trimLines(List<String> lines) {
        ArrayList<String> trimmedLines = new ArrayList<String>(lines.size());
        for (String line : lines) {
            String trimmedLine = line.trim();
            trimmedLines.add(trimmedLine);
        }
        return trimmedLines;
    }

    private List<String> readLines(Reader reader) {
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader bufferedReader = new BufferedReader(reader);
        try {
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                lines.add(line);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot parse lines", e);
        }
        return lines;
    }

    private List<String> replacePlaceholders(List<String> lines, PlaceholderReplacer placeholderReplacer) {
        ArrayList<String> noPlaceholderLines = new ArrayList<String>(lines.size());
        for (String line : lines) {
            noPlaceholderLines.add(placeholderReplacer.replacePlaceholders(line));
        }
        return noPlaceholderLines;
    }
}

