/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.dbsupport.mysql;

import com.googlecode.flyway.core.migration.sql.PlaceholderReplacer;
import com.googlecode.flyway.core.migration.sql.SqlScript;

public class MySQLSqlScript
extends SqlScript {
    private static final String DELIMITER_KEYWORD = "DELIMITER";

    public MySQLSqlScript(String sqlScriptSource, PlaceholderReplacer placeholderReplacer) {
        super(sqlScriptSource, placeholderReplacer);
    }

    @Override
    protected String changeDelimiterIfNecessary(String statement, String line, String delimiter) {
        if (line.toUpperCase().startsWith(DELIMITER_KEYWORD)) {
            return line.substring(DELIMITER_KEYWORD.length()).trim();
        }
        return delimiter;
    }

    @Override
    protected boolean isDelimiterChangeExplicit() {
        return true;
    }

    @Override
    protected boolean isCommentDirective(String line) {
        return line.startsWith("/*!") && line.endsWith("*/;");
    }
}

