/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.metadatatable;

import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.exception.FlywayException;
import com.googlecode.flyway.core.metadatatable.MetaDataTableRow;
import com.googlecode.flyway.core.migration.MigrationState;
import com.googlecode.flyway.core.migration.MigrationType;
import com.googlecode.flyway.core.migration.SchemaVersion;
import com.googlecode.flyway.core.migration.sql.PlaceholderReplacer;
import com.googlecode.flyway.core.migration.sql.SqlScript;
import com.googlecode.flyway.core.util.ResourceUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class MetaDataTable {
    private static final Log LOG = LogFactory.getLog(MetaDataTable.class);
    private final DbSupport dbSupport;
    private final String tableName;
    private final JdbcTemplate jdbcTemplate;
    private final TransactionTemplate transactionTemplate;

    public MetaDataTable(TransactionTemplate transactionTemplate, JdbcTemplate jdbcTemplate, DbSupport dbSupport, String tableName) {
        this.transactionTemplate = transactionTemplate;
        this.jdbcTemplate = jdbcTemplate;
        this.dbSupport = dbSupport;
        this.tableName = tableName;
    }

    private boolean exists() {
        return this.dbSupport.tableExists(this.tableName);
    }

    private void create() {
        String location = this.dbSupport.getScriptLocation() + "createMetaDataTable.sql";
        final String createMetaDataTableScriptSource = ResourceUtils.loadResourceAsString(location);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("tableName", this.tableName);
        final PlaceholderReplacer placeholderReplacer = new PlaceholderReplacer(placeholders, "${", "}");
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                SqlScript sqlScript = new SqlScript(createMetaDataTableScriptSource, placeholderReplacer);
                sqlScript.execute(MetaDataTable.this.jdbcTemplate);
            }
        });
        LOG.info((Object)("Metadata table created: " + this.tableName));
    }

    public void createIfNotExists() {
        if (!this.exists()) {
            this.create();
        }
    }

    public void lock() {
        if (this.dbSupport.supportsLocking()) {
            this.jdbcTemplate.queryForList("SELECT script FROM " + this.tableName + " FOR UPDATE");
        }
    }

    public void insert(MetaDataTableRow metaDataTableRow) {
        this.jdbcTemplate.update("UPDATE " + this.tableName + " SET current_version=" + this.dbSupport.getBooleanFalse());
        String version = metaDataTableRow.getVersion().toString();
        String description = metaDataTableRow.getDescription();
        String state = metaDataTableRow.getState().name();
        String migrationType = metaDataTableRow.getMigrationType().name();
        Integer checksum = metaDataTableRow.getChecksum();
        String scriptName = metaDataTableRow.getScript();
        Integer executionTime = metaDataTableRow.getExecutionTime();
        this.jdbcTemplate.update("INSERT INTO " + this.tableName + " (version, description, type, script, checksum, installed_by, execution_time, state, current_version)" + " VALUES (?, ?, ?, ?, ?, " + this.dbSupport.getCurrentUserFunction() + ", ?, ?, " + this.dbSupport.getBooleanTrue() + ")", new Object[]{version, description, migrationType, scriptName, checksum, executionTime, state});
    }

    private boolean hasRows() {
        if (!this.exists()) {
            return false;
        }
        return this.jdbcTemplate.queryForInt("SELECT COUNT(*) FROM " + this.tableName) > 0;
    }

    public MetaDataTableRow latestAppliedMigration() {
        if (!this.hasRows()) {
            return null;
        }
        String query = this.getSelectStatement() + " where current_version=" + this.dbSupport.getBooleanTrue();
        List metaDataTableRows = this.jdbcTemplate.query(query, (RowMapper)new MetaDataTableRowMapper());
        if (metaDataTableRows.isEmpty()) {
            if (this.hasRows()) {
                throw new FlywayException("Cannot determine latest applied migration. Was the metadata table manually modified?");
            }
            return null;
        }
        return (MetaDataTableRow)metaDataTableRows.get(0);
    }

    public List<MetaDataTableRow> allAppliedMigrations() {
        if (!this.exists()) {
            return new ArrayList<MetaDataTableRow>();
        }
        String query = this.getSelectStatement();
        List metaDataTableRows = this.jdbcTemplate.query(query, (RowMapper)new MetaDataTableRowMapper());
        Collections.sort(metaDataTableRows);
        return metaDataTableRows;
    }

    private String getSelectStatement() {
        return "select VERSION, DESCRIPTION, TYPE, SCRIPT, CHECKSUM, INSTALLED_ON, EXECUTION_TIME, STATE from " + this.tableName;
    }

    private Integer toInteger(Number number) {
        if (number == null) {
            return null;
        }
        return number.intValue();
    }

    public MigrationState getCurrentSchemaState() {
        MetaDataTableRow latestAppliedMigration = this.latestAppliedMigration();
        if (latestAppliedMigration == null) {
            return MigrationState.SUCCESS;
        }
        return latestAppliedMigration.getState();
    }

    public SchemaVersion getCurrentSchemaVersion() {
        MetaDataTableRow latestAppliedMigration = this.latestAppliedMigration();
        if (latestAppliedMigration == null) {
            return SchemaVersion.EMPTY;
        }
        return latestAppliedMigration.getVersion();
    }

    private class MetaDataTableRowMapper
    implements RowMapper {
        private MetaDataTableRowMapper() {
        }

        public MetaDataTableRow mapRow(ResultSet rs, int rowNum) throws SQLException {
            SchemaVersion version = new SchemaVersion(rs.getString("VERSION"));
            String description = rs.getString("DESCRIPTION");
            MigrationType migrationType = MigrationType.valueOf(rs.getString("TYPE"));
            String script = rs.getString("SCRIPT");
            Integer checksum = MetaDataTable.this.toInteger((Number)rs.getObject("CHECKSUM"));
            Timestamp installedOn = rs.getTimestamp("INSTALLED_ON");
            Integer executionTime = MetaDataTable.this.toInteger((Number)rs.getObject("EXECUTION_TIME"));
            MigrationState migrationState = MigrationState.valueOf(rs.getString("STATE"));
            return new MetaDataTableRow(version, description, migrationType, script, checksum, installedOn, executionTime, migrationState);
        }
    }
}

