/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.clean;

import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.exception.FlywayException;
import com.googlecode.flyway.core.migration.sql.SqlScript;
import com.googlecode.flyway.core.util.TimeFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.StopWatch;

public class DbCleaner {
    private static final Log LOG = LogFactory.getLog(DbCleaner.class);
    private final DbSupport dbSupport;
    private final TransactionTemplate transactionTemplate;
    private final JdbcTemplate jdbcTemplate;
    private final String[] schemas;

    public DbCleaner(TransactionTemplate transactionTemplate, JdbcTemplate jdbcTemplate, DbSupport dbSupport, String[] schemas) {
        this.transactionTemplate = transactionTemplate;
        this.jdbcTemplate = jdbcTemplate;
        this.dbSupport = dbSupport;
        this.schemas = schemas;
    }

    public void clean() throws FlywayException {
        for (String schema : this.schemas) {
            this.cleanSchema(schema);
        }
    }

    private void cleanSchema(String schema) {
        LOG.debug((Object)("Starting to drop all database objects in schema '" + schema + "' ..."));
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        final SqlScript cleanScript = this.dbSupport.createCleanScript(schema);
        try {
            this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus status) {
                    cleanScript.execute(DbCleaner.this.jdbcTemplate);
                }
            });
        }
        catch (TransactionException e) {
            throw new FlywayException("Clean failed! Schema: " + schema, e);
        }
        stopWatch.stop();
        LOG.info((Object)String.format("Cleaned database schema '%s' (execution time %s)", schema, TimeFormat.format(stopWatch.getTotalTimeMillis())));
    }
}

