/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.clean;

import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.exception.FlywayException;
import com.googlecode.flyway.core.migration.sql.SqlScript;
import com.googlecode.flyway.core.util.StopWatch;
import com.googlecode.flyway.core.util.TimeFormat;
import com.googlecode.flyway.core.util.jdbc.TransactionCallback;
import com.googlecode.flyway.core.util.jdbc.TransactionException;
import com.googlecode.flyway.core.util.jdbc.TransactionTemplate;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DbCleaner {
    private static final Log LOG = LogFactory.getLog(DbCleaner.class);
    private final DbSupport dbSupport;
    private final TransactionTemplate transactionTemplate;
    private final String[] schemas;

    public DbCleaner(TransactionTemplate transactionTemplate, DbSupport dbSupport, String[] schemas) {
        this.transactionTemplate = transactionTemplate;
        this.dbSupport = dbSupport;
        this.schemas = schemas;
    }

    public void clean() throws FlywayException {
        for (String schema : this.schemas) {
            this.cleanSchema(schema);
        }
    }

    private void cleanSchema(String schema) {
        LOG.debug((Object)("Starting to drop all database objects in schema '" + schema + "' ..."));
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            final SqlScript cleanScript = this.dbSupport.createCleanScript(schema);
            try {
                this.transactionTemplate.execute(new TransactionCallback<Void>(){

                    @Override
                    public Void doInTransaction() {
                        cleanScript.execute(DbCleaner.this.dbSupport.getJdbcTemplate());
                        return null;
                    }
                });
            }
            catch (TransactionException e) {
                throw new FlywayException("Clean failed! Schema: " + schema, e);
            }
        }
        catch (SQLException e) {
            throw new FlywayException("Error while generating clean script", e);
        }
        stopWatch.stop();
        LOG.info((Object)String.format("Cleaned database schema '%s' (execution time %s)", schema, TimeFormat.format(stopWatch.getTotalTimeMillis())));
    }
}

