/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.dbsupport.derby;

import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.dbsupport.SqlScript;
import com.googlecode.flyway.core.dbsupport.SqlStatement;
import com.googlecode.flyway.core.dbsupport.SqlStatementBuilder;
import com.googlecode.flyway.core.dbsupport.derby.DerbyJdbcTemplate;
import com.googlecode.flyway.core.dbsupport.derby.DerbySqlStatementBuilder;
import com.googlecode.flyway.core.util.StringUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DerbyDbSupport
extends DbSupport {
    public DerbyDbSupport(Connection connection) {
        super(new DerbyJdbcTemplate(connection));
    }

    @Override
    public String getScriptLocation() {
        return "com/googlecode/flyway/core/dbsupport/derby/";
    }

    @Override
    public String getCurrentUserFunction() {
        return "CURRENT_USER";
    }

    @Override
    public String getCurrentSchema() throws SQLException {
        return this.jdbcTemplate.queryForString("SELECT CURRENT SCHEMA FROM SYSIBM.SYSDUMMY1", new String[0]);
    }

    @Override
    public void setCurrentSchema(String schema) throws SQLException {
        this.jdbcTemplate.execute("SET SCHEMA " + this.quote(schema), new Object[0]);
    }

    @Override
    public boolean isSchemaEmpty(String schema) throws SQLException {
        return !this.jdbcTemplate.tableExists(null, schema.toUpperCase(), null, new String[0]);
    }

    @Override
    public boolean tableExistsNoQuotes(String schema, String table) throws SQLException {
        return this.jdbcTemplate.tableExists(null, schema.toUpperCase(), table.toUpperCase(), new String[0]);
    }

    @Override
    public boolean tableExists(String schema, String table) throws SQLException {
        return this.jdbcTemplate.tableExists(null, schema, table, new String[0]);
    }

    @Override
    public boolean columnExists(String schema, String table, String column) throws SQLException {
        return this.jdbcTemplate.columnExists(null, schema, table, column);
    }

    @Override
    public boolean supportsDdlTransactions() {
        return true;
    }

    @Override
    public void lockTable(String schema, String table) throws SQLException {
        this.jdbcTemplate.execute("LOCK TABLE " + this.quote(schema) + "." + this.quote(table) + " IN EXCLUSIVE MODE", new Object[0]);
    }

    @Override
    public String getBooleanTrue() {
        return "true";
    }

    @Override
    public String getBooleanFalse() {
        return "false";
    }

    @Override
    public SqlStatementBuilder createSqlStatementBuilder() {
        return new DerbySqlStatementBuilder();
    }

    @Override
    public SqlScript createCleanScript(String schema) throws SQLException {
        List<String> statements = this.generateDropStatementsForConstraints(schema);
        List<String> viewNames = this.listObjectNames("TABLE", "TABLETYPE='V'", schema);
        statements.addAll(this.generateDropStatements("VIEW", viewNames, "", schema));
        List<String> tableNames = this.listObjectNames("TABLE", "TABLETYPE='T'", schema);
        statements.addAll(this.generateDropStatements("TABLE", tableNames, "", schema));
        List<String> sequenceNames = this.listObjectNames("SEQUENCE", "", schema);
        statements.addAll(this.generateDropStatements("SEQUENCE", sequenceNames, "RESTRICT", schema));
        ArrayList<SqlStatement> sqlStatements = new ArrayList<SqlStatement>();
        int lineNumber = 1;
        for (String statement : statements) {
            sqlStatements.add(new SqlStatement(lineNumber, statement));
            ++lineNumber;
        }
        return new SqlScript(sqlStatements, (DbSupport)this);
    }

    private List<String> generateDropStatementsForConstraints(String schema) throws SQLException {
        List<Map<String, String>> results = this.jdbcTemplate.queryForList("SELECT c.constraintname, t.tablename FROM sys.sysconstraints c INNER JOIN sys.systables t ON c.tableid = t.tableid INNER JOIN sys.sysschemas s ON c.schemaid = s.schemaid WHERE c.type = 'F' AND s.schemaname = ?", schema);
        ArrayList<String> statements = new ArrayList<String>();
        for (Map<String, String> result : results) {
            String dropStatement = "ALTER TABLE \"" + schema + "\".\"" + result.get("TABLENAME") + "\"" + " DROP CONSTRAINT \"" + result.get("CONSTRAINTNAME") + "\"";
            statements.add(dropStatement);
        }
        return statements;
    }

    private List<String> generateDropStatements(String objectType, List<String> objectNames, String dropStatementSuffix, String schema) {
        ArrayList<String> statements = new ArrayList<String>();
        for (String objectName : objectNames) {
            String dropStatement = "DROP " + objectType + " \"" + schema + "\".\"" + objectName + "\"" + " " + dropStatementSuffix;
            statements.add(dropStatement);
        }
        return statements;
    }

    private List<String> listObjectNames(String objectType, String querySuffix, String schema) throws SQLException {
        String query = "SELECT " + objectType + "name FROM sys.sys" + objectType + "s WHERE schemaid in (SELECT schemaid FROM sys.sysschemas where schemaname = ?)";
        if (StringUtils.hasLength(querySuffix)) {
            query = query + " AND " + querySuffix;
        }
        return this.jdbcTemplate.queryForStringList(query, schema);
    }

    @Override
    public String doQuote(String identifier) {
        return "\"" + identifier + "\"";
    }
}

