/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core;

import com.googlecode.flyway.core.api.FlywayException;
import com.googlecode.flyway.core.api.MigrationInfo;
import com.googlecode.flyway.core.api.MigrationInfoService;
import com.googlecode.flyway.core.api.MigrationVersion;
import com.googlecode.flyway.core.command.DbClean;
import com.googlecode.flyway.core.command.DbInit;
import com.googlecode.flyway.core.command.DbMigrate;
import com.googlecode.flyway.core.command.DbSchemas;
import com.googlecode.flyway.core.command.DbValidate;
import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.dbsupport.DbSupportFactory;
import com.googlecode.flyway.core.dbsupport.Schema;
import com.googlecode.flyway.core.info.MigrationInfoServiceImpl;
import com.googlecode.flyway.core.metadatatable.MetaDataTable;
import com.googlecode.flyway.core.metadatatable.MetaDataTableImpl;
import com.googlecode.flyway.core.metadatatable.MetaDataTableRow;
import com.googlecode.flyway.core.migration.SchemaVersion;
import com.googlecode.flyway.core.resolver.CompositeMigrationResolver;
import com.googlecode.flyway.core.resolver.MigrationResolver;
import com.googlecode.flyway.core.util.Locations;
import com.googlecode.flyway.core.util.StringUtils;
import com.googlecode.flyway.core.util.jdbc.DriverDataSource;
import com.googlecode.flyway.core.util.jdbc.JdbcUtils;
import com.googlecode.flyway.core.util.logging.Log;
import com.googlecode.flyway.core.util.logging.LogFactory;
import com.googlecode.flyway.core.validation.ValidationErrorMode;
import com.googlecode.flyway.core.validation.ValidationMode;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Flyway {
    private static final Log LOG = LogFactory.getLog(Flyway.class);
    private static final String PLACEHOLDERS_PROPERTY_PREFIX = "flyway.placeholders.";
    private Locations locations = new Locations("db/migration");
    private String encoding = "UTF-8";
    private String[] schemaNames = new String[0];
    private String table = "schema_version";
    private MigrationVersion target = MigrationVersion.LATEST;
    private Map<String, String> placeholders = new HashMap<String, String>();
    private String placeholderPrefix = "${";
    private String placeholderSuffix = "}";
    private String sqlMigrationPrefix = "V";
    private String sqlMigrationSuffix = ".sql";
    private boolean ignoreFailedFutureMigration;
    private boolean validateOnMigrate;
    private boolean cleanOnValidationError;
    private MigrationVersion initVersion = new MigrationVersion("1");
    private String initDescription = "<< Flyway Init >>";
    @Deprecated
    private boolean disableInitCheck;
    private boolean initOnMigrate;
    private boolean outOfOrder;
    private DataSource dataSource;

    public String[] getLocations() {
        String[] result = new String[this.locations.getLocations().size()];
        for (int i = 0; i < this.locations.getLocations().size(); ++i) {
            result[i] = this.locations.getLocations().get(i).toString();
        }
        return result;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String[] getSchemas() {
        return this.schemaNames;
    }

    public String getTable() {
        return this.table;
    }

    public MigrationVersion getTarget() {
        return this.target;
    }

    public Map<String, String> getPlaceholders() {
        return this.placeholders;
    }

    public String getPlaceholderPrefix() {
        return this.placeholderPrefix;
    }

    public String getPlaceholderSuffix() {
        return this.placeholderSuffix;
    }

    public String getSqlMigrationPrefix() {
        return this.sqlMigrationPrefix;
    }

    public String getSqlMigrationSuffix() {
        return this.sqlMigrationSuffix;
    }

    public boolean isIgnoreFailedFutureMigration() {
        return this.ignoreFailedFutureMigration;
    }

    @Deprecated
    public ValidationMode getValidationMode() {
        LOG.warn("validationMode has been deprecated and will be removed in Flyway 3.0. Use validateOnMigrate instead.");
        if (this.validateOnMigrate) {
            return ValidationMode.ALL;
        }
        return ValidationMode.NONE;
    }

    @Deprecated
    public ValidationErrorMode getValidationErrorMode() {
        LOG.warn("validationErrorMode has been deprecated and will be removed in Flyway 3.0. Use cleanOnValidationError instead.");
        if (this.cleanOnValidationError) {
            return ValidationErrorMode.CLEAN;
        }
        return ValidationErrorMode.FAIL;
    }

    public boolean isValidateOnMigrate() {
        return this.validateOnMigrate;
    }

    public boolean isCleanOnValidationError() {
        return this.cleanOnValidationError;
    }

    @Deprecated
    public MigrationVersion getInitialVersion() {
        LOG.warn("Flyway.getInitialVersion() has been deprecated. Use getInitVersion() instead. Will be removed in Flyway 3.0.");
        return this.initVersion;
    }

    @Deprecated
    public String getInitialDescription() {
        LOG.warn("Flyway.getInitialDescription() has been deprecated. Use getInitDescription() instead. Will be removed in Flyway 3.0.");
        return this.initDescription;
    }

    public MigrationVersion getInitVersion() {
        return this.initVersion;
    }

    public String getInitDescription() {
        return this.initDescription;
    }

    @Deprecated
    public boolean isDisableInitCheck() {
        return this.disableInitCheck;
    }

    public boolean isInitOnMigrate() {
        return this.initOnMigrate;
    }

    public boolean isOutOfOrder() {
        return this.outOfOrder;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setIgnoreFailedFutureMigration(boolean ignoreFailedFutureMigration) {
        this.ignoreFailedFutureMigration = ignoreFailedFutureMigration;
    }

    @Deprecated
    public void setValidationMode(ValidationMode validationMode) {
        LOG.warn("validationMode has been deprecated and will be removed in Flyway 3.0. Use validateOnMigrate instead.");
        this.validateOnMigrate = ValidationMode.ALL == validationMode;
    }

    @Deprecated
    public void setValidationErrorMode(ValidationErrorMode validationErrorMode) {
        LOG.warn("validationErrorMode has been deprecated and will be removed in Flyway 3.0. Use cleanOnValidationError instead.");
        this.cleanOnValidationError = ValidationErrorMode.CLEAN == validationErrorMode;
    }

    public void setValidateOnMigrate(boolean validateOnMigrate) {
        this.validateOnMigrate = validateOnMigrate;
    }

    public void setCleanOnValidationError(boolean cleanOnValidationError) {
        this.cleanOnValidationError = cleanOnValidationError;
    }

    public void setLocations(String ... locations) {
        this.locations = new Locations(locations);
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setSchemas(String ... schemas) {
        this.schemaNames = schemas;
    }

    public void setTable(String table) {
        this.table = table;
    }

    @Deprecated
    public void setTarget(SchemaVersion target) {
        LOG.warn("Flyway.setTarget(SchemaVersion) has been deprecated. Use setTarget(MigrationVersion) instead. Will be removed in Flyway 3.0.");
        this.target = new MigrationVersion(target.toString());
    }

    public void setTarget(MigrationVersion target) {
        this.target = target;
    }

    public void setTarget(String target) {
        this.target = new MigrationVersion(target);
    }

    public void setPlaceholders(Map<String, String> placeholders) {
        this.placeholders = placeholders;
    }

    public void setPlaceholderPrefix(String placeholderPrefix) {
        this.placeholderPrefix = placeholderPrefix;
    }

    public void setPlaceholderSuffix(String placeholderSuffix) {
        this.placeholderSuffix = placeholderSuffix;
    }

    public void setSqlMigrationPrefix(String sqlMigrationPrefix) {
        this.sqlMigrationPrefix = sqlMigrationPrefix;
    }

    public void setSqlMigrationSuffix(String sqlMigrationSuffix) {
        this.sqlMigrationSuffix = sqlMigrationSuffix;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setDataSource(String url, String user, String password) {
        this.dataSource = new DriverDataSource(null, url, user, password, new String[0]);
    }

    @Deprecated
    public void setInitialVersion(SchemaVersion initialVersion) {
        LOG.warn("Flyway.setInitialVersion(SchemaVersion) has been deprecated. Use setInitVersion(MigrationVersion) instead. Will be removed in Flyway 3.0.");
        this.initVersion = new MigrationVersion(initialVersion.toString());
    }

    @Deprecated
    public void setInitialVersion(MigrationVersion initialVersion) {
        LOG.warn("Flyway.setInitialVersion(MigrationVersion) has been deprecated. Use setInitVersion(MigrationVersion) instead. Will be removed in Flyway 3.0.");
        this.initVersion = initialVersion;
    }

    @Deprecated
    public void setInitialVersion(String initialVersion) {
        LOG.warn("Flyway.setInitialVersion(String) has been deprecated. Use setInitVersion(String) instead. Will be removed in Flyway 3.0.");
        this.initVersion = new MigrationVersion(initialVersion);
    }

    @Deprecated
    public void setInitialDescription(String initialDescription) {
        LOG.warn("Flyway.setInitialDescription(String) has been deprecated. Use setInitDescription(String instead. Will be removed in Flyway 3.0.");
        this.initDescription = initialDescription;
    }

    public void setInitVersion(MigrationVersion initVersion) {
        this.initVersion = initVersion;
    }

    public void setInitVersion(String initVersion) {
        this.initVersion = new MigrationVersion(initVersion);
    }

    public void setInitDescription(String initDescription) {
        this.initDescription = initDescription;
    }

    @Deprecated
    public void setDisableInitCheck(boolean disableInitCheck) {
        this.disableInitCheck = disableInitCheck;
    }

    public void setInitOnMigrate(boolean initOnMigrate) {
        this.initOnMigrate = initOnMigrate;
    }

    public void setOutOfOrder(boolean outOfOrder) {
        this.outOfOrder = outOfOrder;
    }

    public int migrate() throws FlywayException {
        return this.execute(new Command<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer execute(Connection connectionMetaDataTable, Connection connectionUserObjects, DbSupport dbSupport, Schema[] schemas) {
                MigrationResolver migrationResolver = Flyway.this.createMigrationResolver();
                MetaDataTableImpl metaDataTable = new MetaDataTableImpl(dbSupport, schemas[0].getTable(Flyway.this.table), migrationResolver);
                if (Flyway.this.validateOnMigrate) {
                    Flyway.this.doValidate(connectionMetaDataTable, migrationResolver, metaDataTable, schemas);
                }
                new DbSchemas(connectionMetaDataTable, schemas, metaDataTable).create();
                if (!(metaDataTable.hasSchemasMarker() || metaDataTable.hasInitMarker() || metaDataTable.hasAppliedMigrations())) {
                    ArrayList<Schema> nonEmptySchemas = new ArrayList<Schema>();
                    for (Schema schema : schemas) {
                        if (schema.empty()) continue;
                        nonEmptySchemas.add(schema);
                    }
                    if (Flyway.this.initOnMigrate || Flyway.this.disableInitCheck || nonEmptySchemas.isEmpty()) {
                        if (Flyway.this.initOnMigrate && !nonEmptySchemas.isEmpty()) {
                            new DbInit(connectionMetaDataTable, metaDataTable, Flyway.this.initVersion, Flyway.this.initDescription).init();
                        }
                    } else if (nonEmptySchemas.size() == 1) {
                        Schema schema = (Schema)nonEmptySchemas.get(0);
                        if (schema.allTables().length != 1 || !schema.getTable(Flyway.this.table).exists()) {
                            throw new FlywayException("Found non-empty schema " + schema + " without metadata table! Use init() first to initialize the metadata table.");
                        }
                    } else {
                        throw new FlywayException("Found non-empty schemas " + StringUtils.collectionToCommaDelimitedString(nonEmptySchemas) + " without metadata table! Use init() first to initialize the metadata table.");
                    }
                }
                DbSupport dbSupportUserObjects = DbSupportFactory.createDbSupport(connectionUserObjects);
                Schema schemaUserObjects = dbSupport.getCurrentSchema();
                if (!schemas[0].equals(schemaUserObjects)) {
                    dbSupportUserObjects.setCurrentSchema(schemas[0]);
                }
                DbMigrate dbMigrator = new DbMigrate(connectionMetaDataTable, connectionUserObjects, dbSupport, metaDataTable, schemas[0], migrationResolver, Flyway.this.target, Flyway.this.ignoreFailedFutureMigration, Flyway.this.outOfOrder);
                try {
                    Integer n = dbMigrator.migrate();
                    return n;
                }
                finally {
                    if (!schemaUserObjects.equals(dbSupportUserObjects.getCurrentSchema())) {
                        dbSupportUserObjects.setCurrentSchema(schemaUserObjects);
                    }
                }
            }
        });
    }

    public void validate() throws FlywayException {
        this.execute(new Command<Void>(){

            @Override
            public Void execute(Connection connectionMetaDataTable, Connection connectionUserObjects, DbSupport dbSupport, Schema[] schemas) {
                MigrationResolver migrationResolver = Flyway.this.createMigrationResolver();
                MetaDataTableImpl metaDataTable = new MetaDataTableImpl(dbSupport, schemas[0].getTable(Flyway.this.table), migrationResolver);
                Flyway.this.doValidate(connectionMetaDataTable, migrationResolver, metaDataTable, schemas);
                return null;
            }
        });
    }

    private void doValidate(Connection connectionMetaDataTable, MigrationResolver migrationResolver, MetaDataTable metaDataTable, Schema[] schemas) {
        String validationError = new DbValidate(connectionMetaDataTable, metaDataTable, migrationResolver, this.target, this.outOfOrder).validate();
        if (validationError != null) {
            if (this.cleanOnValidationError) {
                new DbClean(connectionMetaDataTable, metaDataTable, schemas).clean();
            } else {
                throw new FlywayException("Validate failed. Found differences between applied migrations and available migrations: " + validationError);
            }
        }
    }

    public void clean() {
        this.execute(new Command<Void>(){

            @Override
            public Void execute(Connection connectionMetaDataTable, Connection connectionUserObjects, DbSupport dbSupport, Schema[] schemas) {
                MetaDataTableImpl metaDataTable = new MetaDataTableImpl(dbSupport, schemas[0].getTable(Flyway.this.table), Flyway.this.createMigrationResolver());
                new DbClean(connectionMetaDataTable, metaDataTable, schemas).clean();
                return null;
            }
        });
    }

    @Deprecated
    public MetaDataTableRow status() {
        LOG.warn("Flyway.status() has been deprecated and will be removed in Flyway 3.0. Use Flyway.info().current() instead.");
        MigrationInfo current = this.info().current();
        if (current == null) {
            return null;
        }
        return new MetaDataTableRow(current);
    }

    @Deprecated
    public List<MetaDataTableRow> history() {
        LOG.warn("Flyway.history() has been deprecated and will be removed in Flyway 3.0. Use Flyway.info().applied() instead.");
        MigrationInfo[] migrationInfos = this.info().applied();
        ArrayList<MetaDataTableRow> metaDataTableRows = new ArrayList<MetaDataTableRow>();
        for (MigrationInfo migrationInfo : migrationInfos) {
            metaDataTableRows.add(new MetaDataTableRow(migrationInfo));
        }
        return metaDataTableRows;
    }

    public MigrationInfoService info() {
        return this.execute(new Command<MigrationInfoService>(){

            @Override
            public MigrationInfoService execute(Connection connectionMetaDataTable, Connection connectionUserObjects, DbSupport dbSupport, Schema[] schemas) {
                MigrationResolver migrationResolver = Flyway.this.createMigrationResolver();
                MetaDataTableImpl metaDataTable = new MetaDataTableImpl(dbSupport, schemas[0].getTable(Flyway.this.table), migrationResolver);
                MigrationInfoServiceImpl migrationInfoService = new MigrationInfoServiceImpl(migrationResolver, metaDataTable, Flyway.this.target, Flyway.this.outOfOrder);
                migrationInfoService.refresh();
                return migrationInfoService;
            }
        });
    }

    public void init() throws FlywayException {
        this.execute(new Command<Void>(){

            @Override
            public Void execute(Connection connectionMetaDataTable, Connection connectionUserObjects, DbSupport dbSupport, Schema[] schemas) {
                MigrationResolver migrationResolver = Flyway.this.createMigrationResolver();
                MetaDataTableImpl metaDataTable = new MetaDataTableImpl(dbSupport, schemas[0].getTable(Flyway.this.table), migrationResolver);
                new DbSchemas(connectionMetaDataTable, schemas, metaDataTable).create();
                new DbInit(connectionMetaDataTable, metaDataTable, Flyway.this.initVersion, Flyway.this.initDescription).init();
                return null;
            }
        });
    }

    public void repair() throws FlywayException {
        this.execute(new Command<Void>(){

            @Override
            public Void execute(Connection connectionMetaDataTable, Connection connectionUserObjects, DbSupport dbSupport, Schema[] schemas) {
                new MetaDataTableImpl(dbSupport, schemas[0].getTable(Flyway.this.table), Flyway.this.createMigrationResolver()).repair();
                return null;
            }
        });
    }

    private MigrationResolver createMigrationResolver() {
        return new CompositeMigrationResolver(this.locations, this.encoding, this.sqlMigrationPrefix, this.sqlMigrationSuffix, this.placeholders, this.placeholderPrefix, this.placeholderSuffix);
    }

    public void configure(Properties properties) {
        String outOfOrderProp;
        String targetProp;
        String ignoreFailedFutureMigrationProp;
        String initOnMigrateProp;
        String disableInitCheckProp;
        String initDescriptionProp;
        String initVersionProp;
        String initialDescriptionProp;
        String initialVersionProp;
        String validateOnMigrateProp;
        String cleanOnValidationErrorProp;
        String validationModeProp;
        String validationErrorModeProp;
        String tableProp;
        String schemasProp;
        String encodingProp;
        String sqlMigrationSuffixProp;
        String sqlMigrationPrefixProp;
        String placeholderSuffixProp;
        String placeholderPrefixProp;
        String driverProp = properties.getProperty("flyway.driver");
        String urlProp = properties.getProperty("flyway.url");
        String userProp = properties.getProperty("flyway.user");
        String passwordProp = properties.getProperty("flyway.password");
        if (StringUtils.hasText(urlProp)) {
            this.setDataSource(new DriverDataSource(driverProp, urlProp, userProp, passwordProp, new String[0]));
        } else if (!StringUtils.hasText(urlProp) && (StringUtils.hasText(driverProp) || StringUtils.hasText(userProp) || StringUtils.hasText(passwordProp))) {
            LOG.warn("Discarding INCOMPLETE dataSource configuration! flyway.url must be set.");
        }
        String locationsProp = properties.getProperty("flyway.locations");
        if (locationsProp != null) {
            this.setLocations(StringUtils.tokenizeToStringArray(locationsProp, ","));
        }
        if ((placeholderPrefixProp = properties.getProperty("flyway.placeholderPrefix")) != null) {
            this.setPlaceholderPrefix(placeholderPrefixProp);
        }
        if ((placeholderSuffixProp = properties.getProperty("flyway.placeholderSuffix")) != null) {
            this.setPlaceholderSuffix(placeholderSuffixProp);
        }
        if ((sqlMigrationPrefixProp = properties.getProperty("flyway.sqlMigrationPrefix")) != null) {
            this.setSqlMigrationPrefix(sqlMigrationPrefixProp);
        }
        if ((sqlMigrationSuffixProp = properties.getProperty("flyway.sqlMigrationSuffix")) != null) {
            this.setSqlMigrationSuffix(sqlMigrationSuffixProp);
        }
        if ((encodingProp = properties.getProperty("flyway.encoding")) != null) {
            this.setEncoding(encodingProp);
        }
        if ((schemasProp = properties.getProperty("flyway.schemas")) != null) {
            this.setSchemas(StringUtils.tokenizeToStringArray(schemasProp, ","));
        }
        if ((tableProp = properties.getProperty("flyway.table")) != null) {
            this.setTable(tableProp);
        }
        if ((validationErrorModeProp = properties.getProperty("flyway.validationErrorMode")) != null) {
            this.setValidationErrorMode(ValidationErrorMode.valueOf(validationErrorModeProp));
        }
        if ((validationModeProp = properties.getProperty("flyway.validationMode")) != null) {
            this.setValidationMode(ValidationMode.valueOf(validationModeProp));
        }
        if ((cleanOnValidationErrorProp = properties.getProperty("flyway.cleanOnValidationError")) != null) {
            this.setCleanOnValidationError(Boolean.parseBoolean(cleanOnValidationErrorProp));
        }
        if ((validateOnMigrateProp = properties.getProperty("flyway.validateOnMigrate")) != null) {
            this.setValidateOnMigrate(Boolean.parseBoolean(validateOnMigrateProp));
        }
        if ((initialVersionProp = properties.getProperty("flyway.initialVersion")) != null) {
            this.setInitialVersion(new MigrationVersion(initialVersionProp));
        }
        if ((initialDescriptionProp = properties.getProperty("flyway.initialDescription")) != null) {
            this.setInitialDescription(initialDescriptionProp);
        }
        if ((initVersionProp = properties.getProperty("flyway.initVersion")) != null) {
            this.setInitVersion(new MigrationVersion(initVersionProp));
        }
        if ((initDescriptionProp = properties.getProperty("flyway.initDescription")) != null) {
            this.setInitDescription(initDescriptionProp);
        }
        if ((disableInitCheckProp = properties.getProperty("flyway.disableInitCheck")) != null) {
            this.setDisableInitCheck(Boolean.parseBoolean(disableInitCheckProp));
        }
        if ((initOnMigrateProp = properties.getProperty("flyway.initOnMigrate")) != null) {
            this.setInitOnMigrate(Boolean.parseBoolean(initOnMigrateProp));
        }
        if ((ignoreFailedFutureMigrationProp = properties.getProperty("flyway.ignoreFailedFutureMigration")) != null) {
            this.setIgnoreFailedFutureMigration(Boolean.parseBoolean(ignoreFailedFutureMigrationProp));
        }
        if ((targetProp = properties.getProperty("flyway.target")) != null) {
            this.setTarget(new MigrationVersion(targetProp));
        }
        if ((outOfOrderProp = properties.getProperty("flyway.outOfOrder")) != null) {
            this.setOutOfOrder(Boolean.parseBoolean(outOfOrderProp));
        }
        HashMap<String, String> placeholdersFromProps = new HashMap<String, String>();
        for (Object property : properties.keySet()) {
            String propertyName = (String)property;
            if (!propertyName.startsWith(PLACEHOLDERS_PROPERTY_PREFIX) || propertyName.length() <= PLACEHOLDERS_PROPERTY_PREFIX.length()) continue;
            String placeholderName = propertyName.substring(PLACEHOLDERS_PROPERTY_PREFIX.length());
            String placeholderValue = properties.getProperty(propertyName);
            placeholdersFromProps.put(placeholderName, placeholderValue);
        }
        this.setPlaceholders(placeholdersFromProps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T execute(Command<T> command) {
        T result;
        Connection connectionMetaDataTable = null;
        Connection connectionUserObjects = null;
        try {
            Schema currentSchema;
            if (this.dataSource == null) {
                throw new FlywayException("DataSource not set! Check your configuration!");
            }
            connectionMetaDataTable = JdbcUtils.openConnection(this.dataSource);
            connectionUserObjects = JdbcUtils.openConnection(this.dataSource);
            DbSupport dbSupport = DbSupportFactory.createDbSupport(connectionMetaDataTable);
            LOG.debug("DDL Transactions Supported: " + dbSupport.supportsDdlTransactions());
            if (this.schemaNames.length == 0 && (currentSchema = dbSupport.getCurrentSchema()) != null) {
                this.setSchemas(currentSchema.getName());
            }
            if (this.schemaNames.length == 1) {
                LOG.debug("Schema: " + this.schemaNames[0]);
            } else {
                LOG.debug("Schemas: " + StringUtils.arrayToCommaDelimitedString(this.schemaNames));
            }
            Schema[] schemas = new Schema[this.schemaNames.length];
            for (int i = 0; i < this.schemaNames.length; ++i) {
                schemas[i] = dbSupport.getSchema(this.schemaNames[i]);
            }
            result = command.execute(connectionMetaDataTable, connectionUserObjects, dbSupport, schemas);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeConnection(connectionUserObjects);
            JdbcUtils.closeConnection(connectionMetaDataTable);
            throw throwable;
        }
        JdbcUtils.closeConnection(connectionUserObjects);
        JdbcUtils.closeConnection(connectionMetaDataTable);
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface Command<T> {
        public T execute(Connection var1, Connection var2, DbSupport var3, Schema[] var4);
    }
}

