/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.flyway.maven;

import com.google.code.flyway.core.Flyway;
import java.sql.Driver;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.springframework.jdbc.datasource.SimpleDriverDataSource;

public class MigrateMojo
extends AbstractMojo {
    private String driver = null;
    private String url;
    private String user;
    private String password = "";
    private String basePackage;
    private String baseDir;
    private String schemaMetaDataTable;
    private Map<String, String> placeholders;

    public void execute() throws MojoExecutionException {
        try {
            Driver driverClazz = (Driver)Class.forName(this.driver).newInstance();
            SimpleDriverDataSource dataSource = new SimpleDriverDataSource(driverClazz, this.url, this.user, this.password);
            Flyway flyway = new Flyway();
            flyway.setDataSource((DataSource)dataSource);
            if (this.basePackage != null) {
                flyway.setBasePackage(this.basePackage);
            }
            if (this.baseDir != null) {
                flyway.setBaseDir(this.baseDir);
            }
            if (this.schemaMetaDataTable != null) {
                flyway.setSchemaMetaDataTable(this.schemaMetaDataTable);
            }
            if (this.placeholders != null) {
                flyway.setPlaceholders(this.placeholders);
            }
            flyway.migrate();
        }
        catch (ClassNotFoundException e) {
            throw new MojoExecutionException("Unable to find driver class: " + this.driver, (Exception)e);
        }
        catch (InstantiationException e) {
            throw new MojoExecutionException("Unable to instantiate driver class: " + this.driver, (Exception)e);
        }
        catch (IllegalAccessException e) {
            throw new MojoExecutionException("Unable to access driver class: " + this.driver, (Exception)e);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error migrating database: " + e.getMessage(), e);
        }
    }
}

