/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.maven;

import com.googlecode.flyway.core.Flyway;
import com.googlecode.flyway.maven.AbstractFlywayMojo;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.project.MavenProject;

public class MigrateMojo
extends AbstractFlywayMojo {
    private static final String ADDITIONAL_PLACEHOLDERS_PROPERTY_PREFIX = "flyway.placeholders.";
    private String basePackage;
    private String baseDir;
    private String encoding;
    private String schemaMetaDataTable;
    private Map<String, String> placeholders;
    private String placeholderPrefix = "${";
    private String placeholderSuffix = "}";
    private MavenProject mavenProject;

    @Override
    protected void doExecute() throws Exception {
        Flyway flyway = new Flyway();
        flyway.setDataSource(this.getDataSource());
        if (this.basePackage != null) {
            flyway.setBasePackage(this.basePackage);
        }
        if (this.baseDir != null) {
            flyway.setBaseDir(this.baseDir);
        }
        if (this.encoding != null) {
            flyway.setEncoding(this.encoding);
        }
        if (this.schemaMetaDataTable != null) {
            flyway.setSchemaMetaDataTable(this.schemaMetaDataTable);
        }
        HashMap<String, String> mergedPlaceholders = new HashMap<String, String>();
        this.addPlaceholdersFromProperties(mergedPlaceholders, this.mavenProject.getProperties());
        this.addPlaceholdersFromProperties(mergedPlaceholders, System.getProperties());
        if (this.placeholders != null) {
            mergedPlaceholders.putAll(this.placeholders);
        }
        flyway.setPlaceholders(mergedPlaceholders);
        if (this.placeholderPrefix != null) {
            flyway.setPlaceholderPrefix(this.placeholderPrefix);
        }
        if (this.placeholderSuffix != null) {
            flyway.setPlaceholderSuffix(this.placeholderSuffix);
        }
        flyway.migrate();
    }

    private void addPlaceholdersFromProperties(Map<String, String> placeholders, Properties properties) {
        for (Object property : properties.keySet()) {
            String propertyName = (String)property;
            if (!propertyName.startsWith(ADDITIONAL_PLACEHOLDERS_PROPERTY_PREFIX) || propertyName.length() <= ADDITIONAL_PLACEHOLDERS_PROPERTY_PREFIX.length()) continue;
            String placeholderName = propertyName.substring(ADDITIONAL_PLACEHOLDERS_PROPERTY_PREFIX.length());
            String placeholderValue = properties.getProperty(propertyName);
            placeholders.put(placeholderName, placeholderValue);
        }
    }
}

