/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.maven;

import com.googlecode.flyway.core.migration.Migration;
import com.googlecode.flyway.core.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MigrationDumper {
    private static final Log LOG = LogFactory.getLog(MigrationDumper.class);

    private MigrationDumper() {
    }

    public static void dumpMigrations(List<Migration> migrations) {
        LOG.info((Object)"+-------------+------------------------+---------------------+---------+");
        LOG.info((Object)"| Version     | Description            | Installed on        | State   |");
        LOG.info((Object)"+-------------+------------------------+---------------------+---------+");
        if (migrations.isEmpty()) {
            LOG.info((Object)"| No migrations applied yet                                            |");
        } else {
            for (Migration migration : migrations) {
                LOG.info((Object)("| " + StringUtils.trimOrPad((String)migration.getVersion().getVersion(), (int)11) + " | " + StringUtils.trimOrPad((String)migration.getVersion().getDescription(), (int)22) + " | " + StringUtils.trimOrPad((String)MigrationDumper.formatInstalledOnDate(migration.getInstalledOn()), (int)19) + " | " + StringUtils.trimOrPad((String)migration.getState().name(), (int)7) + " |"));
            }
        }
        LOG.info((Object)"+-------------+------------------------+---------------------+---------+");
    }

    private static String formatInstalledOnDate(Date installedOn) {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(installedOn);
    }
}

