/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.maven;

import com.pyx4j.log4j.MavenLogAppender;
import java.sql.Driver;
import javax.sql.DataSource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.springframework.jdbc.datasource.SimpleDriverDataSource;

abstract class AbstractFlywayMojo
extends AbstractMojo {
    protected String driver = null;
    protected String url;
    protected String user;
    protected String password = "";

    AbstractFlywayMojo() {
    }

    protected DataSource getDataSource() throws MojoExecutionException {
        try {
            Driver driverClazz = (Driver)Class.forName(this.driver).newInstance();
            return new SimpleDriverDataSource(driverClazz, this.url, this.user, this.password);
        }
        catch (ClassNotFoundException e) {
            throw new MojoExecutionException("Unable to find driver class: " + this.driver, (Exception)e);
        }
        catch (InstantiationException e) {
            throw new MojoExecutionException("Unable to instantiate driver class: " + this.driver, (Exception)e);
        }
        catch (IllegalAccessException e) {
            throw new MojoExecutionException("Unable to access driver class: " + this.driver, (Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute() throws MojoExecutionException, MojoFailureException {
        MavenLogAppender.startPluginLog((AbstractMojo)this);
        try {
            this.doExecute();
        }
        finally {
            MavenLogAppender.endPluginLog((AbstractMojo)this);
        }
    }

    protected abstract void doExecute() throws MojoExecutionException, MojoFailureException;
}

