/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.maven;

import com.googlecode.flyway.core.Flyway;
import com.googlecode.flyway.core.validation.ValidationErrorMode;
import com.googlecode.flyway.core.validation.ValidationMode;
import com.googlecode.flyway.maven.AbstractMigrationLoadingMojo;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.project.MavenProject;

public class MigrateMojo
extends AbstractMigrationLoadingMojo {
    private static final String ADDITIONAL_PLACEHOLDERS_PROPERTY_PREFIX = "flyway.placeholders.";
    private Map<String, String> placeholders;
    private String placeholderPrefix;
    private String placeholderSuffix;
    private String validationMode;
    private String validationErrorMode;
    private MavenProject mavenProject;

    @Override
    protected void doExecute(Flyway flyway) throws Exception {
        super.doExecute(flyway);
        HashMap<String, String> mergedPlaceholders = new HashMap<String, String>();
        this.addPlaceholdersFromProperties(mergedPlaceholders, this.mavenProject.getProperties());
        this.addPlaceholdersFromProperties(mergedPlaceholders, System.getProperties());
        if (this.placeholders != null) {
            mergedPlaceholders.putAll(this.placeholders);
        }
        flyway.setPlaceholders(mergedPlaceholders);
        if (this.placeholderPrefix != null) {
            flyway.setPlaceholderPrefix(this.placeholderPrefix);
        }
        if (this.placeholderSuffix != null) {
            flyway.setPlaceholderSuffix(this.placeholderSuffix);
        }
        if (this.validationMode != null) {
            flyway.setValidationMode(ValidationMode.valueOf((String)this.validationMode.toUpperCase()));
        }
        if (this.validationErrorMode != null) {
            flyway.setValidationErrorMode(ValidationErrorMode.valueOf((String)this.validationErrorMode.toUpperCase()));
        }
        flyway.migrate();
    }

    private void addPlaceholdersFromProperties(Map<String, String> placeholders, Properties properties) {
        for (Object property : properties.keySet()) {
            String propertyName = (String)property;
            if (!propertyName.startsWith(ADDITIONAL_PLACEHOLDERS_PROPERTY_PREFIX) || propertyName.length() <= ADDITIONAL_PLACEHOLDERS_PROPERTY_PREFIX.length()) continue;
            String placeholderName = propertyName.substring(ADDITIONAL_PLACEHOLDERS_PROPERTY_PREFIX.length());
            String placeholderValue = properties.getProperty(propertyName);
            placeholders.put(placeholderName, placeholderValue);
        }
    }
}

