/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.maven;

import com.googlecode.flyway.core.Flyway;
import com.googlecode.flyway.core.util.ExceptionUtils;
import com.pyx4j.log4j.MavenLogAppender;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

abstract class AbstractFlywayMojo
extends AbstractMojo {
    private static final Log LOG = LogFactory.getLog(AbstractFlywayMojo.class);
    private String driver;
    private String url;
    private String user;
    private String password = "";
    private String table;

    AbstractFlywayMojo() {
    }

    private DataSource createDataSource() throws Exception {
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setDriverClassName(this.driver);
        dataSource.setUrl(this.url);
        dataSource.setUsername(this.user);
        dataSource.setPassword(this.password);
        return dataSource;
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        MavenLogAppender.startPluginLog((AbstractMojo)this);
        try {
            Flyway flyway = new Flyway();
            if (this.table != null) {
                flyway.setTable(this.table);
            }
            flyway.setDataSource(this.createDataSource());
            this.doExecute(flyway);
        }
        catch (Exception e) {
            LOG.error((Object)e.toString());
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
            if (rootCause != null) {
                LOG.error((Object)("Caused by " + rootCause.toString()));
            }
            throw new MojoExecutionException("Flyway Error: " + e.toString(), e);
        }
        finally {
            MavenLogAppender.endPluginLog((AbstractMojo)this);
        }
    }

    protected abstract void doExecute(Flyway var1) throws Exception;
}

