/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.maven;

import com.googlecode.flyway.core.Flyway;
import com.googlecode.flyway.core.migration.MigrationProvider;
import com.googlecode.flyway.core.migration.SchemaVersion;
import com.googlecode.flyway.core.validation.ValidationErrorMode;
import com.googlecode.flyway.core.validation.ValidationMode;
import com.googlecode.flyway.maven.AbstractMigrationLoadingMojo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.project.MavenProject;

public class MigrateMojo
extends AbstractMigrationLoadingMojo {
    private static final Log LOG = LogFactory.getLog(MigrateMojo.class);
    private static final String PLACEHOLDERS_PROPERTY_PREFIX = "flyway.placeholders.";
    private String target;
    private boolean ignoreFailedFutureMigration;
    private Map<String, String> placeholders;
    private String placeholderPrefix;
    private String placeholderSuffix;
    private String validationMode;
    private String validationErrorMode;
    private boolean disableInitCheck;
    private MavenProject mavenProject;

    @Override
    protected void doExecute(Flyway flyway) throws Exception {
        super.doExecute(flyway);
        if (this.target != null) {
            flyway.setTarget(new SchemaVersion(this.target));
        }
        flyway.setIgnoreFailedFutureMigration(this.ignoreFailedFutureMigration);
        HashMap<String, String> mergedPlaceholders = new HashMap<String, String>();
        MigrateMojo.addPlaceholdersFromProperties(mergedPlaceholders, this.mavenProject.getProperties());
        MigrateMojo.addPlaceholdersFromProperties(mergedPlaceholders, System.getProperties());
        if (this.placeholders != null) {
            mergedPlaceholders.putAll(this.placeholders);
        }
        flyway.setPlaceholders(mergedPlaceholders);
        if (this.placeholderPrefix != null) {
            flyway.setPlaceholderPrefix(this.placeholderPrefix);
        }
        if (this.placeholderSuffix != null) {
            flyway.setPlaceholderSuffix(this.placeholderSuffix);
        }
        if (this.validationMode != null) {
            flyway.setValidationMode(ValidationMode.valueOf((String)this.validationMode.toUpperCase()));
        }
        if (this.validationErrorMode != null) {
            flyway.setValidationErrorMode(ValidationErrorMode.valueOf((String)this.validationErrorMode.toUpperCase()));
        }
        flyway.setDisableInitCheck(this.disableInitCheck);
        MigrationProvider migrationProvider = new MigrationProvider(flyway.getBasePackage(), flyway.getBaseDir(), flyway.getEncoding(), flyway.getSqlMigrationPrefix(), flyway.getSqlMigrationSuffix(), flyway.getPlaceholders(), flyway.getPlaceholderPrefix(), flyway.getPlaceholderSuffix());
        List availableMigrations = migrationProvider.findAvailableMigrations();
        if (availableMigrations.isEmpty()) {
            LOG.warn((Object)"Possible solution: run mvn compile first so Flyway can find the migrations");
            return;
        }
        flyway.migrate();
    }

    private static void addPlaceholdersFromProperties(Map<String, String> placeholders, Properties properties) {
        for (Object property : properties.keySet()) {
            String propertyName = (String)property;
            if (!propertyName.startsWith(PLACEHOLDERS_PROPERTY_PREFIX) || propertyName.length() <= PLACEHOLDERS_PROPERTY_PREFIX.length()) continue;
            String placeholderName = propertyName.substring(PLACEHOLDERS_PROPERTY_PREFIX.length());
            String placeholderValue = properties.getProperty(propertyName);
            placeholders.put(placeholderName, placeholderValue);
        }
    }
}

