/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.maven;

import com.googlecode.flyway.core.Flyway;
import com.googlecode.flyway.core.exception.FlywayException;
import com.googlecode.flyway.core.util.ExceptionUtils;
import com.pyx4j.log4j.MavenLogAppender;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.springframework.util.StringUtils;

abstract class AbstractFlywayMojo
extends AbstractMojo {
    private static final Log LOG = LogFactory.getLog(AbstractFlywayMojo.class);
    String driver;
    String url;
    String user;
    private String password = "";
    private String schemas;
    private String table;
    private Settings settings;
    private String serverId = "flyway-db";

    AbstractFlywayMojo() {
    }

    private void loadCredentialsFromSettings() throws FlywayException {
        if (this.user == null) {
            Server server = this.settings.getServer(this.serverId);
            if (server == null) {
                throw new FlywayException(String.format("Database username missing. It was not specified as a property and it was not defined in settings.xml for the server with the id '%s'", this.serverId));
            }
            this.user = server.getUsername();
            this.password = server.getPassword();
        }
    }

    BasicDataSource createDataSource() throws Exception {
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setDriverClassName(this.driver);
        dataSource.setUrl(this.url);
        dataSource.setUsername(this.user);
        dataSource.setPassword(this.password);
        return dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute() throws MojoExecutionException, MojoFailureException {
        MavenLogAppender.startPluginLog((AbstractMojo)this);
        try {
            Flyway flyway = new Flyway();
            this.loadCredentialsFromSettings();
            BasicDataSource dataSource = this.createDataSource();
            try {
                flyway.setDataSource((DataSource)dataSource);
                if (this.schemas != null) {
                    flyway.setSchemas(StringUtils.tokenizeToStringArray((String)this.schemas, (String)","));
                }
                if (this.table != null) {
                    flyway.setTable(this.table);
                }
                this.doExecute(flyway);
            }
            finally {
                dataSource.close();
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.toString());
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
            if (rootCause != null) {
                LOG.error((Object)("Caused by " + rootCause.toString()));
            }
            throw new MojoExecutionException("Flyway Error: " + e.toString(), e);
        }
        finally {
            MavenLogAppender.endPluginLog((AbstractMojo)this);
        }
    }

    protected abstract void doExecute(Flyway var1) throws Exception;
}

