/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.maven;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.classworlds.ClassRealm;
import org.codehaus.plexus.component.configurator.AbstractComponentConfigurator;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.codehaus.plexus.component.configurator.converters.ConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.composite.ObjectWithFieldsConverter;
import org.codehaus.plexus.component.configurator.converters.special.ClassRealmConverter;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncludeProjectDependenciesComponentConfigurator
extends AbstractComponentConfigurator {
    private static final Log LOGGER = LogFactory.getLog(IncludeProjectDependenciesComponentConfigurator.class);

    public void configureComponent(Object component, PlexusConfiguration configuration, ExpressionEvaluator expressionEvaluator, ClassRealm containerRealm, ConfigurationListener listener) throws ComponentConfigurationException {
        this.addProjectDependenciesToClassRealm(expressionEvaluator, containerRealm);
        this.converterLookup.registerConverter((ConfigurationConverter)new ClassRealmConverter(containerRealm));
        ObjectWithFieldsConverter converter = new ObjectWithFieldsConverter();
        converter.processConfiguration(this.converterLookup, component, containerRealm.getClassLoader(), configuration, expressionEvaluator, listener);
    }

    private void addProjectDependenciesToClassRealm(ExpressionEvaluator expressionEvaluator, ClassRealm containerRealm) throws ComponentConfigurationException {
        URL[] urls;
        List runtimeClasspathElements;
        try {
            runtimeClasspathElements = (List)expressionEvaluator.evaluate("${project.runtimeClasspathElements}");
        }
        catch (ExpressionEvaluationException e) {
            throw new ComponentConfigurationException("There was a problem evaluating: ${project.runtimeClasspathElements}", (Throwable)e);
        }
        for (URL url : urls = this.buildURLs(runtimeClasspathElements)) {
            containerRealm.addConstituent(url);
        }
    }

    private URL[] buildURLs(List<String> runtimeClasspathElements) throws ComponentConfigurationException {
        ArrayList<URL> urls = new ArrayList<URL>(runtimeClasspathElements.size());
        for (String element : runtimeClasspathElements) {
            try {
                URL url = new File(element).toURI().toURL();
                urls.add(url);
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug((Object)("Added to project class loader: " + url));
            }
            catch (MalformedURLException e) {
                throw new ComponentConfigurationException("Unable to access project dependency: " + element, (Throwable)e);
            }
        }
        return urls.toArray(new URL[urls.size()]);
    }
}

