/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.maven;

import com.googlecode.flyway.core.Flyway;
import com.googlecode.flyway.core.api.FlywayException;
import com.googlecode.flyway.core.util.ExceptionUtils;
import com.googlecode.flyway.core.util.StringUtils;
import com.googlecode.flyway.core.util.jdbc.DriverDataSource;
import com.googlecode.flyway.core.util.logging.Log;
import com.googlecode.flyway.core.util.logging.LogCreator;
import com.googlecode.flyway.core.util.logging.LogFactory;
import com.googlecode.flyway.maven.MavenLogCreator;
import javax.sql.DataSource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;

abstract class AbstractFlywayMojo
extends AbstractMojo {
    protected Log log;
    String driver;
    String url;
    String user;
    private String password;
    private String[] schemas;
    private String table;
    private String serverId = "flyway-db";
    private Settings settings;
    protected MavenProject mavenProject;

    AbstractFlywayMojo() {
    }

    private void loadCredentialsFromSettings() throws FlywayException {
        Server server;
        if (this.user == null && (server = this.settings.getServer(this.serverId)) != null) {
            this.user = server.getUsername();
            this.password = server.getPassword();
        }
    }

    DataSource createDataSource() throws Exception {
        return new DriverDataSource(this.driver, this.url, this.user, this.password, new String[0]);
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        LogFactory.setLogCreator((LogCreator)new MavenLogCreator(this));
        this.log = LogFactory.getLog(((Object)((Object)this)).getClass());
        try {
            this.loadCredentialsFromSettings();
            Flyway flyway = new Flyway();
            flyway.setDataSource(this.createDataSource());
            String schemasProperty = this.mavenProject.getProperties().getProperty("flyway.schemas");
            if (schemasProperty != null) {
                flyway.setLocations(StringUtils.tokenizeToStringArray((String)schemasProperty, (String)","));
            } else if (this.schemas != null) {
                flyway.setSchemas(this.schemas);
            }
            if (this.table != null) {
                flyway.setTable(this.table);
            }
            this.doExecute(flyway);
        }
        catch (Exception e) {
            this.log.error(e.toString());
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
            if (rootCause != null) {
                this.log.error("Caused by " + rootCause.toString());
            }
            throw new MojoExecutionException("Flyway Error: " + e.toString(), e);
        }
    }

    protected abstract void doExecute(Flyway var1) throws Exception;
}

