/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.sample.appengine;

import com.googlecode.flyway.core.Flyway;
import com.googlecode.flyway.core.metadatatable.MetaDataTableRow;
import com.googlecode.flyway.core.util.DateUtils;
import com.googlecode.flyway.sample.appengine.DataSourceFactory;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HistoryServlet
extends HttpServlet {
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        throw new ServletException("POST not supported");
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Flyway flyway = new Flyway();
        flyway.setDataSource(DataSourceFactory.createDataSource());
        List metaDataTableRows = flyway.history();
        response.setContentType("application/json");
        PrintWriter writer = response.getWriter();
        writer.print("{\"status\":\"OK\", \"rows\":[");
        boolean first = true;
        for (MetaDataTableRow row : metaDataTableRows) {
            if (!first) {
                writer.print(",");
            }
            writer.print("{\"version\":\"" + row.getVersion() + "\",");
            String description = row.getDescription() == null ? "" : row.getDescription();
            writer.print("\"description\":\"" + description + "\",");
            writer.print("\"installedOn\":\"" + DateUtils.formatDateAsIsoString((Date)row.getInstalledOn()) + "\",");
            writer.print("\"state\":\"" + row.getState().name() + "\"}");
            first = false;
        }
        writer.print("]}");
    }
}

