/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.ibaguice.datasource.dbcp;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import javax.sql.ConnectionPoolDataSource;
import org.apache.commons.dbcp.cpdsadapter.DriverAdapterCPDS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public final class DriverAdapterCPDSProvider
implements Provider<ConnectionPoolDataSource> {
    private final DriverAdapterCPDS adapter = new DriverAdapterCPDS();

    @Inject
    public DriverAdapterCPDSProvider(@Named(value="JDBC.driver") String driver, @Named(value="JDBC.url") String url, @Named(value="JDBC.username") String username, @Named(value="JDBC.password") String password) {
        try {
            this.adapter.setDriver(driver);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Driver '" + driver + "' not found in the classpath", e);
        }
        this.adapter.setUrl(url);
        this.adapter.setUser(username);
        this.adapter.setPassword(password);
    }

    @Inject(optional=true)
    public void setDescription(@Named(value="DBCP.description") String description) {
        this.adapter.setDescription(description);
    }

    @Inject(optional=true)
    public void setLoginTimeout(@Named(value="JDBC.loginTimeout") int seconds) {
        this.adapter.setLoginTimeout(seconds);
    }

    @Inject(optional=true)
    public void setMaxActive(@Named(value="DBCP.maxActive") int maxActive) {
        this.adapter.setMaxActive(maxActive);
    }

    @Inject(optional=true)
    public void setMaxIdle(@Named(value="DBCP.maxIdle") int maxIdle) {
        this.adapter.setMaxIdle(maxIdle);
    }

    @Inject(optional=true)
    public void setMaxPreparedStatements(@Named(value="DBCP.maxOpenPreparedStatements") int maxPreparedStatements) {
        this.adapter.setMaxPreparedStatements(maxPreparedStatements);
    }

    @Inject(optional=true)
    public void setMinEvictableIdleTimeMillis(@Named(value="DBCP.minEvictableIdleTimeMillis") int minEvictableIdleTimeMillis) {
        this.adapter.setMinEvictableIdleTimeMillis(minEvictableIdleTimeMillis);
    }

    @Inject(optional=true)
    public void setNumTestsPerEvictionRun(@Named(value="DBCP.numTestsPerEvictionRun") int numTestsPerEvictionRun) {
        this.adapter.setNumTestsPerEvictionRun(numTestsPerEvictionRun);
    }

    @Inject(optional=true)
    public void setPoolPreparedStatements(@Named(value="DBCP.poolPreparedStatements") boolean poolPreparedStatements) {
        this.adapter.setPoolPreparedStatements(poolPreparedStatements);
    }

    @Inject(optional=true)
    public void setTimeBetweenEvictionRunsMillis(@Named(value="DBCP.timeBetweenEvictionRunsMillis") int timeBetweenEvictionRunsMillis) {
        this.adapter.setTimeBetweenEvictionRunsMillis(timeBetweenEvictionRunsMillis);
    }

    public ConnectionPoolDataSource get() {
        return this.adapter;
    }
}

