/*
 *    Copyright 2009-2010 The iBaGuice Team
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */
package com.googlecode.ibaguice.core;

import org.apache.ibatis.session.SqlSessionFactory;

import com.google.inject.AbstractModule;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import com.google.inject.matcher.Matchers;
import com.googlecode.ibaguice.core.dao.SqlSessionRegistry;
import com.googlecode.ibaguice.core.dao.Transactional;
import com.googlecode.ibaguice.core.dao.TransactionalMethodInterceptor;

/**
 *
 * @version $Id: AbstractSqlSessionFactoryModule.java 2098 2010-06-04 14:13:52Z simone.tripodi $
 */
abstract class AbstractSqlSessionFactoryModule extends AbstractModule {

    private final Class<? extends Provider<SqlSessionFactory>> sqlSessionFactoryProviderType;

    public AbstractSqlSessionFactoryModule(Class<? extends Provider<SqlSessionFactory>> sqlSessionFactoryProviderType) {
        this.sqlSessionFactoryProviderType = sqlSessionFactoryProviderType;
    }

    @Override
    protected void configure() {
        this.bind(SqlSessionFactory.class).toProvider(this.sqlSessionFactoryProviderType).in(Scopes.SINGLETON);

        TransactionalMethodInterceptor interceptor = new TransactionalMethodInterceptor();
        this.binder().requestInjection(interceptor);
        this.bindInterceptor(Matchers.any(), Matchers.annotatedWith(Transactional.class), interceptor);
        this.bind(SqlSessionRegistry.class).in(Scopes.SINGLETON);
    }

}
