/*
 *    Copyright 2009-2010 The iBaGuice Team
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */
package com.googlecode.ibaguice.core.dao;

import java.util.List;

import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

import com.google.inject.Inject;

/**
 *
 *
 * @version $Id: AbstractTransactionalDao.java 2095 2010-06-04 13:56:24Z simone.tripodi $
 */
public abstract class AbstractTransactionalDao extends AbstractDao {

    /**
     * The ThreadLocal instance.
     * Used to share the {@code SqlSession} instance with {@code Interceptor}
     */
    @Inject
    private SqlSessionRegistry sqlSessionRegistry;

    /**
     * @param sqlSessionRegistry the sqlSessionRegistry to set
     */
    public void setSqlSessionRegistry(SqlSessionRegistry sqlSessionRegistry) {
        this.sqlSessionRegistry = sqlSessionRegistry;
    }

    protected Object selectOne(String statement) {
        return this.sqlSessionRegistry.selectOne(statement);
    }

    protected Object selectOne(String statement, Object parameter) {
        return this.sqlSessionRegistry.selectOne(statement, parameter);
    }

    @SuppressWarnings("unchecked")
    protected List selectList(String statement) {
        return this.sqlSessionRegistry.selectList(statement);
    }

    @SuppressWarnings("unchecked")
    protected List selectList(String statement, Object parameter) {
        return this.sqlSessionRegistry.selectList(statement, parameter);
    }

    @SuppressWarnings("unchecked")
    protected List selectList(String statement, Object parameter, RowBounds rowBounds) {
        return this.sqlSessionRegistry.selectList(statement, parameter, rowBounds);
    }

    protected void select(String statement, Object parameter, ResultHandler handler) {
        this.sqlSessionRegistry.select(statement, parameter, handler);
    }

    protected void select(String statement, Object parameter, RowBounds rowBounds, ResultHandler handler) {
        this.sqlSessionRegistry.select(statement, parameter, rowBounds, handler);
    }

    protected int insert(String statement) {
        return this.sqlSessionRegistry.insert(statement);
    }

    protected int insert(String statement, Object parameter) {
        return this.sqlSessionRegistry.insert(statement, parameter);
    }

    protected int update(String statement) {
        return this.sqlSessionRegistry.update(statement);
    }

    protected int update(String statement, Object parameter) {
        return this.sqlSessionRegistry.update(statement, parameter);
    }

    protected int delete(String statement) {
        return this.sqlSessionRegistry.delete(statement);
    }

    protected int delete(String statement, Object parameter) {
        return this.sqlSessionRegistry.delete(statement, parameter);
    }

    protected <T> T getMapper(Class<T> type) {
        return this.sqlSessionRegistry.getMapper(type);
    }

}
