/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.icegem.expiration;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.client.ClientCacheFactory;
import com.gemstone.gemfire.cache.client.ClientRegionFactory;
import com.gemstone.gemfire.cache.client.ClientRegionShortcut;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.googlecode.icegem.expiration.DestroyedEntriesCountCollector;
import com.googlecode.icegem.expiration.ExpirationFunction;
import com.googlecode.icegem.expiration.ExpirationFunctionArguments;
import com.googlecode.icegem.expiration.ExpirationPolicy;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpirationController {
    private Logger logger = LoggerFactory.getLogger(ExpirationController.class);
    private ClientCache cache;
    private ClientRegionFactory<Object, Object> clientRegionFactory;

    public ExpirationController(ClientCache cache, ClientRegionFactory<Object, Object> clientRegionFactory) {
        this.logger.info("Creating the ExpirationController");
        this.cache = cache;
        this.clientRegionFactory = clientRegionFactory;
        this.logger.info("ExpirationController with parameters cache = " + cache + ", clientRegionFactory = " + clientRegionFactory + " has been created");
    }

    public ExpirationController(String locatorHost, int locatorPort) {
        this.logger.info("Creating the ExpirationController");
        try {
            if (locatorHost == null || locatorHost.trim().length() == 0) {
                throw new IllegalArgumentException("The locator host \"" + locatorHost + "\" is incorrect");
            }
            if (locatorPort < 0 || locatorPort > 65535) {
                throw new IllegalArgumentException("The locator port \"" + locatorPort + "\" is incorrect. It should be in range [0, 65535]");
            }
            this.cache = new ClientCacheFactory().set("log-level", "warning").addPoolLocator(locatorHost, locatorPort).create();
            this.clientRegionFactory = this.cache.createClientRegionFactory(ClientRegionShortcut.PROXY);
        }
        catch (RuntimeException re) {
            this.logger.error("RuntimeException during creating of ExpirationController", (Throwable)re);
            throw re;
        }
        this.logger.info("ExpirationController with parameters locatorHost = " + locatorHost + ", locatorPort = " + locatorPort + " has been created");
    }

    public long process(String regionName, ExpirationPolicy policy, long packetSize, long packetDelay) {
        long destroyedEntriesNumber = 0L;
        try {
            if (this.cache == null) {
                throw new IllegalStateException("It seems that the workflow of the controller is already finished");
            }
            if (regionName == null || regionName.trim().length() == 0) {
                throw new IllegalArgumentException("The region name \"" + regionName + "\" is incorrect");
            }
            if (policy == null) {
                throw new IllegalArgumentException("The ExpirationPolicy cannot be null");
            }
            Region region = this.cache.getRegion(regionName);
            if (region == null) {
                region = this.clientRegionFactory.create(regionName);
            }
            if (region == null) {
                throw new IllegalStateException("Cannot retrieve access to the region with name \"" + regionName + "\"");
            }
            this.logger.info("Running ExpirationController process with parameters regionName = " + regionName + ", policy = " + policy + ", packetSize = " + packetSize + ", packetDelay = " + packetDelay);
            DestroyedEntriesCountCollector collector = (DestroyedEntriesCountCollector)FunctionService.onRegion((Region)region).withArgs((Serializable)new ExpirationFunctionArguments(packetSize, packetDelay)).withCollector((ResultCollector)new DestroyedEntriesCountCollector()).execute((Function)new ExpirationFunction(policy));
            Serializable result = collector.getResult();
            if (result instanceof Long) {
                destroyedEntriesNumber = (Long)result;
            }
            this.logger.info("ExpirationController process with parameters regionName = " + regionName + ", policy = " + policy + ", packetSize = " + packetSize + ", packetDelay = " + packetDelay + " has destroyed " + destroyedEntriesNumber + " entries");
        }
        catch (RuntimeException re) {
            this.logger.error("RuntimeException during processing", (Throwable)re);
            throw re;
        }
        return destroyedEntriesNumber;
    }

    public long process(String regionName, ExpirationPolicy policy) {
        return this.process(regionName, policy, 1L, 0L);
    }

    public void close() {
        this.logger.info("Closing the ExpirationController");
        if (this.cache != null) {
            this.cache.close();
        }
        this.logger.info("The ExpirationController has been closed");
    }
}

