/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.icegem.expiration;

import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.RegionFunctionContext;
import com.gemstone.gemfire.cache.execute.ResultSender;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import com.googlecode.icegem.expiration.ExpirationFunctionArguments;
import com.googlecode.icegem.expiration.ExpirationPolicy;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpirationFunction
extends FunctionAdapter
implements Declarable {
    private static final long serialVersionUID = -6448375948152121283L;
    private Logger logger = LoggerFactory.getLogger(ExpirationFunction.class);
    private ExpirationPolicy policy;

    public ExpirationFunction(ExpirationPolicy policy) {
        this.policy = policy;
    }

    public void init(Properties arg0) {
    }

    public void execute(FunctionContext functionContext) {
        ResultSender resultSender;
        long destroyedEntriesCount;
        block7: {
            this.logger.debug("Starting expiration");
            destroyedEntriesCount = 0L;
            resultSender = functionContext.getResultSender();
            try {
                if (!(functionContext instanceof RegionFunctionContext)) break block7;
                RegionFunctionContext context = (RegionFunctionContext)functionContext;
                Serializable arguments = context.getArguments();
                if (arguments instanceof ExpirationFunctionArguments) {
                    ExpirationFunctionArguments expirationFunctionArguments = (ExpirationFunctionArguments)arguments;
                    long packetDelay = expirationFunctionArguments.getPacketDelay();
                    long packetSize = expirationFunctionArguments.getPacketSize();
                    this.logger.debug("Expiration configured with packetSize = " + packetSize + ", packetDelay = " + packetDelay);
                    Region region = PartitionRegionHelper.getLocalDataForContext((RegionFunctionContext)context);
                    Set entrySet = region.entrySet();
                    int numberOfEntries = entrySet.size();
                    this.logger.debug("There are " + numberOfEntries + " entries to check");
                    this.logger.debug("Starting the check");
                    long packetCounter = 1L;
                    for (Map.Entry entry : entrySet) {
                        if (packetDelay > 0L && packetCounter % packetSize == 0L) {
                            this.logger.debug("Checking the " + packetCounter + " of " + numberOfEntries + " entry.");
                            Thread.sleep(packetDelay);
                        }
                        if (entry instanceof Region.Entry) {
                            Region.Entry regionEntry = (Region.Entry)entry;
                            if (this.policy != null && this.policy.isExpired((Region.Entry<Object, Object>)regionEntry)) {
                                Object key = entry.getKey();
                                this.logger.trace("Destroing the entry with key " + key);
                                region.destroy(key);
                                ++destroyedEntriesCount;
                            }
                        }
                        ++packetCounter;
                    }
                    this.logger.debug("The check is finished. " + destroyedEntriesCount + " entries have been destroyed.");
                    break block7;
                }
                throw new IllegalArgumentException("The specified arguments are of type \"" + arguments.getClass().getName() + "\". Should be of type \"" + ExpirationFunctionArguments.class.getName() + "\"");
            }
            catch (Throwable t) {
                this.logger.error("Throwable during the expiration processing", t);
                resultSender.sendException(t);
            }
        }
        resultSender.lastResult((Serializable)Long.valueOf(destroyedEntriesCount));
    }

    public String getId() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

