/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.icegem.query.bucketoriented;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.query.QueryException;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.internal.ResultsCollectionWrapper;
import com.gemstone.gemfire.cache.query.types.ObjectType;
import com.googlecode.icegem.query.bucketoriented.BucketOrientedQueryFunction;
import com.googlecode.icegem.query.bucketoriented.BucketOrientedQueryFunctionArgument;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BucketOrientedQueryService {
    private static Logger logger = LoggerFactory.getLogger(BucketOrientedQueryService.class);

    public static SelectResults<Object> executeOnBuckets(String queryString, Region region, Set<Object> keys) throws QueryException {
        return BucketOrientedQueryService.executeOnBuckets(queryString, null, region, keys);
    }

    public static SelectResults<Object> executeOnBuckets(String queryString, Object[] queryParameters, Region region, Set<Object> keys) throws QueryException {
        List queryResults;
        if (queryString == null || queryString.length() == 0) {
            throw new QueryException("You must specify query string for execution");
        }
        int[] limitInfo = BucketOrientedQueryService.extractLimit(queryString);
        if (limitInfo[0] != -1) {
            queryString = queryString.substring(0, limitInfo[1]);
        }
        BucketOrientedQueryFunctionArgument functionArgument = new BucketOrientedQueryFunctionArgument(queryString, queryParameters);
        BucketOrientedQueryFunction function = new BucketOrientedQueryFunction();
        FunctionService.registerFunction((Function)function);
        try {
            queryResults = (List)((Object)FunctionService.onRegion((Region)region).withFilter(keys).withArgs((Serializable)functionArgument).execute((Function)function).getResult());
        }
        catch (FunctionException e) {
            logger.warn(e.getMessage());
            throw new QueryException(e.getMessage());
        }
        return BucketOrientedQueryService.formatSelectResults(queryResults, limitInfo[0]);
    }

    private static int[] extractLimit(String queryString) {
        int limitIndex = queryString.lastIndexOf("limit");
        if (limitIndex == -1) {
            limitIndex = queryString.lastIndexOf("LIMIT");
        }
        if (limitIndex == -1) {
            return new int[]{-1, -1};
        }
        String limitNumber = queryString.substring(limitIndex + 5);
        return new int[]{Integer.parseInt(limitNumber.trim()), limitIndex};
    }

    private static SelectResults<Object> formatSelectResults(List<List<Object>> queryResults, int limit) {
        ArrayList<Object> list = new ArrayList<Object>();
        ObjectType baseElementType = null;
        for (List<Object> queryResult : queryResults) {
            ObjectType elementType = (ObjectType)queryResult.remove(queryResult.size() - 1);
            if (baseElementType == null) {
                baseElementType = elementType;
            } else if (!baseElementType.equals(elementType)) {
                throw new IllegalStateException("Collection types for query result are different");
            }
            list.addAll(queryResult);
        }
        return limit == -1 ? new ResultsCollectionWrapper(baseElementType, list) : new ResultsCollectionWrapper(baseElementType, list, limit);
    }
}

