/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.icegem.serialization;

import com.googlecode.icegem.serialization.codegen.impl.ToDataFieldProcessor;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration {
    private static boolean JAVA_SERIALIZATION_ENABLED = !Boolean.getBoolean("icegem.java.serialization.disabled");
    private Set<Class<?>> gemFireResolvedClasses = new HashSet();

    public Configuration() {
        this.gemFireResolvedClasses.add(Object.class);
        this.gemFireResolvedClasses.add(Object[].class);
        this.gemFireResolvedClasses.add(List.class);
        this.gemFireResolvedClasses.add(Map.class);
        this.gemFireResolvedClasses.add(Set.class);
    }

    public static Configuration getCurrent() {
        return new Configuration();
    }

    public boolean isJavaSerializationEnabled() {
        return JAVA_SERIALIZATION_ENABLED;
    }

    public void setJavaSerializationEnabled(boolean value) {
        JAVA_SERIALIZATION_ENABLED = value;
    }

    public boolean isCustomRegisteredClass(Class<?> clazz) {
        return clazz.getName().startsWith("com.googlecode.gemfire.");
    }

    public boolean useGemFireDataSerializerResolving(Class<?> clazz) {
        return this.gemFireResolvedClasses.contains(clazz);
    }

    public boolean serializeByHand(Class<?> clazz) {
        return new ToDataFieldProcessor().map.containsKey(clazz);
    }

    public String getDataSerializerPackage() {
        return "com.googlecode.icegem.serialization.$$$";
    }
}

