/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.icegem.serialization.codegen;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeGenUtils {
    public static String TAB = "    ";

    public static String tab(String str) {
        return CodeGenUtils.tab(1, str);
    }

    public static String tab(int tabCount, String str) {
        String[] arr = str.split("\n");
        StringBuilder result = new StringBuilder();
        for (String s : arr) {
            for (int i = 1; i <= tabCount; ++i) {
                result.append(TAB);
            }
            result.append(s).append("\n");
        }
        if (!str.endsWith("\n")) {
            return result.substring(0, result.length() - 1);
        }
        return result.toString();
    }

    public static String firstLetterToUpperCase(String fieldName) {
        return fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
    }

    public static String firstLetterToLowerCase(String fieldName) {
        return fieldName.substring(0, 1).toLowerCase() + fieldName.substring(1);
    }

    public static String className(Class<?> clazz) {
        String naiveName = clazz.getName();
        if (!clazz.isArray()) {
            return naiveName;
        }
        int count = 0;
        String ending = "";
        while (clazz.isArray()) {
            ++count;
            ending = ending + "[]";
            clazz = clazz.getComponentType();
        }
        if (clazz.isPrimitive()) {
            String primitiveClassName;
            if (clazz == Boolean.TYPE) {
                primitiveClassName = "boolean";
            } else if (clazz == Byte.TYPE) {
                primitiveClassName = "byte";
            } else if (clazz == Character.TYPE) {
                primitiveClassName = "char";
            } else if (clazz == Short.TYPE) {
                primitiveClassName = "short";
            } else if (clazz == Integer.TYPE) {
                primitiveClassName = "int";
            } else if (clazz == Long.TYPE) {
                primitiveClassName = "long";
            } else if (clazz == Float.TYPE) {
                primitiveClassName = "float";
            } else if (clazz == Double.TYPE) {
                primitiveClassName = "double";
            } else {
                throw new RuntimeException("Never here! - You try to generate code for Void[]...[]: clazz = " + clazz);
            }
            return primitiveClassName + ending;
        }
        return naiveName.substring(count + 1, naiveName.length() - 1) + ending;
    }
}

