/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.icegem.serialization.codegen;

import com.googlecode.icegem.serialization.AutoSerializable;
import com.googlecode.icegem.serialization.SinceVersion;
import com.googlecode.icegem.serialization.Transient;
import com.googlecode.icegem.serialization.codegen.XProperty;
import java.io.InvalidClassException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Introspector {
    public static void checkClassIsSerialized(Class<?> clazz) throws InvalidClassException {
        Introspector.checkClassIsAnnotationMarked(clazz);
        Introspector.checkClassIsPublic(clazz);
        Introspector.checkClassIsNotNested(clazz);
        Constructor<?> constructor = Introspector.checkConstructorNoArg(clazz);
        Introspector.checkConstructorPublic(constructor);
        Introspector.checkConstructorWithoutExceptions(constructor);
        Introspector.checkParentConstructor(clazz);
        Map<String, Method> gettersMap = Introspector.getPropertyGetters(clazz);
        for (Map.Entry<String, Method> getterEntry : gettersMap.entrySet()) {
            Method getter = getterEntry.getValue();
            Introspector.checkGetterPublic(getter);
            Introspector.checkGetterNoArg(getter);
            Introspector.checkGetterWithoutExceptions(getter);
            Method setter = Introspector.getSetterForGetter(clazz, getter);
            Introspector.checkSetterPublic(setter);
            Introspector.checkSetterOneArg(setter);
            Introspector.checkSetterReturnVoid(setter);
            Introspector.checkSetterWithoutExceptions(setter);
            Introspector.checkGetterSetterTheSameType(getter, setter);
        }
    }

    public static List<XProperty> getProperties(Class<?> clazz) {
        try {
            Introspector.checkClassIsSerialized(clazz);
        }
        catch (InvalidClassException e) {
            throw new RuntimeException("Method call getFields(...) for not serialized class " + clazz.getName() + " is incorrect", e);
        }
        Map<String, Method> gettersMap = Introspector.getPropertyGetters(clazz);
        ArrayList<XProperty> result = new ArrayList<XProperty>();
        for (Map.Entry<String, Method> entry : gettersMap.entrySet()) {
            Method method = entry.getValue();
            int sinceVersion = Introspector.getMethodSinceVersion(method);
            boolean isBoolean = false;
            if (method.getName().startsWith("is")) {
                isBoolean = true;
            }
            result.add(new XProperty(entry.getKey(), method.getReturnType(), method.getDeclaringClass(), sinceVersion, isBoolean));
        }
        return result;
    }

    private static int getMethodSinceVersion(Method method) {
        int sinceVersion = 1;
        SinceVersion annotation = method.getAnnotation(SinceVersion.class);
        if (annotation != null && (sinceVersion = annotation.value()) < 1) {
            throw new IllegalArgumentException("@SinceVersion must be positive at " + method);
        }
        return sinceVersion;
    }

    protected static void checkParentConstructor(Class<?> clazz) throws InvalidClassException {
        if (clazz != Object.class) {
            Class<?> parentClazz = clazz.getSuperclass();
            try {
                Introspector.checkConstructorNoArg(parentClazz);
            }
            catch (InvalidClassException e) {
                Introspector.checkClassIsAnnotationMarked(parentClazz);
            }
        }
    }

    protected static void checkGetterSetterTheSameType(Method getter, Method setter) throws InvalidClassException {
        Class<?> setterType;
        Class<?> getterType = getter.getReturnType();
        if (getterType != (setterType = setter.getParameterTypes()[0])) {
            throw new InvalidClassException("Setter " + setter.getName() + " in class " + setter.getDeclaringClass().getName() + " return " + setter.getReturnType().getName() + " but getter " + getter.getName() + " in class " + getter.getDeclaringClass().getName() + " has as parameter type " + getterType);
        }
    }

    protected static void checkSetterReturnVoid(Method setter) throws InvalidClassException {
        if (setter.getReturnType() != Void.TYPE) {
            throw new InvalidClassException("Setter " + setter.getName() + " in class " + setter.getDeclaringClass().getName() + " return not void but " + setter.getReturnType().getName());
        }
    }

    private static Method getSetterForGetter(Class<?> clazz, Method getter) throws InvalidClassException {
        String fieldName = "";
        String name = getter.getName();
        if (name.startsWith("get")) {
            fieldName = name.substring(3, 4).toUpperCase() + name.substring(4);
        } else if (name.startsWith("is")) {
            fieldName = name.substring(2, 3).toUpperCase() + name.substring(3);
        }
        String setterName = "set" + fieldName;
        Class<?> param = getter.getReturnType();
        try {
            return clazz.getMethod(setterName, param);
        }
        catch (NoSuchMethodException e) {
            throw new InvalidClassException("There is no public setter with param type " + param.getName() + " for getter " + name + " in class " + clazz.getName());
        }
    }

    protected static void checkSetterWithoutExceptions(Method setter) throws InvalidClassException {
        Class<?>[] exceptions = setter.getExceptionTypes();
        if (exceptions.length != 0) {
            throw new InvalidClassException("Setter " + setter.getName() + " in class " + setter.getDeclaringClass().getName() + " throws exceptions " + Arrays.asList(exceptions));
        }
    }

    protected static void checkGetterWithoutExceptions(Method getter) throws InvalidClassException {
        Class<?>[] exceptions = getter.getExceptionTypes();
        if (exceptions.length != 0) {
            throw new InvalidClassException("Getter " + getter.getName() + " in class " + getter.getDeclaringClass().getName() + " throws exceptions " + Arrays.asList(exceptions));
        }
    }

    protected static Map<String, Method> getPropertyGetters(Class<?> clazz) {
        HashMap<String, Method> result = new HashMap<String, Method>();
        if (clazz != Object.class) {
            Method[] methodArr;
            for (Method method : methodArr = clazz.getMethods()) {
                if (!Introspector.isNameSuitableForGetter(method) || method.getDeclaringClass() == Object.class || method.isBridge()) continue;
                Annotation[] annArr = method.getDeclaredAnnotations();
                boolean find = false;
                for (Annotation ann : annArr) {
                    if (ann.annotationType() != Transient.class) continue;
                    find = true;
                    break;
                }
                if (find) continue;
                String fieldName = method.getReturnType() == Boolean.TYPE && method.getName().startsWith("is") ? method.getName().substring(2, 3).toLowerCase() + method.getName().substring(3) : method.getName().substring(3, 4).toLowerCase() + method.getName().substring(4);
                result.put(fieldName, method);
            }
            clazz = clazz.getSuperclass();
        }
        return result;
    }

    private static boolean isNameSuitableForGetter(Method method) {
        String propFirstChar = "";
        if (method.getName().startsWith("get") && method.getName().length() > 3) {
            propFirstChar = method.getName().substring(3, 4);
        } else if (method.getReturnType() == Boolean.TYPE && method.getName().startsWith("is") && method.getName().length() > 2) {
            propFirstChar = method.getName().substring(2, 3);
        }
        return propFirstChar.length() != 0 && propFirstChar.toUpperCase().equals(propFirstChar);
    }

    protected static void checkSetterPublic(Method setter) throws InvalidClassException {
        if (!Modifier.isPublic(setter.getModifiers())) {
            throw new InvalidClassException("Setter " + setter.getName() + "in class " + setter.getDeclaringClass() + " is not public but " + Modifier.toString(setter.getModifiers()));
        }
    }

    protected static void checkSetterOneArg(Method setter) throws InvalidClassException {
        Class<?>[] types = setter.getParameterTypes();
        if (types.length != 1) {
            throw new InvalidClassException("Setter " + setter.getName() + " in class " + setter.getDeclaringClass() + " do not have 1 arg but" + types.length + ": " + Arrays.asList(types));
        }
    }

    protected static void checkGetterPublic(Method getter) throws InvalidClassException {
        if (!Modifier.isPublic(getter.getModifiers())) {
            throw new InvalidClassException("Getter " + getter.getName() + " in class " + getter.getDeclaringClass() + " is not public but " + Modifier.toString(getter.getModifiers()));
        }
    }

    protected static void checkGetterNoArg(Method getter) throws InvalidClassException {
        Class<?>[] types = getter.getParameterTypes();
        if (types.length != 0) {
            throw new InvalidClassException("Getter " + getter.getName() + " in class " + getter.getDeclaringClass() + " have arg " + Arrays.asList(types));
        }
    }

    protected static void checkClassIsAnnotationMarked(Class<?> clazz) throws InvalidClassException {
        if (clazz.getAnnotation(AutoSerializable.class) == null) {
            throw new InvalidClassException("Class " + clazz.getName() + " do not contains annotation @" + AutoSerializable.class.getSimpleName());
        }
    }

    protected static void checkClassIsPublic(Class<?> clazz) throws InvalidClassException {
        if (!Modifier.isPublic(clazz.getModifiers())) {
            throw new InvalidClassException("Class " + clazz.getName() + " is not public but " + Modifier.toString(clazz.getModifiers()));
        }
    }

    protected static void checkClassIsNotNested(Class<?> clazz) throws InvalidClassException {
        if (clazz.getEnclosingClass() != null) {
            throw new InvalidClassException("Class " + clazz.getName() + " is not top_level and has enclosing class " + clazz.getEnclosingClass().getName());
        }
    }

    protected static Constructor<?> checkConstructorNoArg(Class<?> clazz) throws InvalidClassException {
        try {
            return clazz.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new InvalidClassException("Class " + clazz.getName() + " haven't got public no-arg constructor");
        }
    }

    protected static void checkConstructorPublic(Constructor<?> constructor) throws InvalidClassException {
        if (!Modifier.isPublic(constructor.getModifiers())) {
            throw new InvalidClassException("No-arg constructor of class " + constructor.getDeclaringClass().getName() + " is not public");
        }
    }

    protected static void checkConstructorWithoutExceptions(Constructor<?> constructor) throws InvalidClassException {
        Class<?>[] exceptions = constructor.getExceptionTypes();
        if (exceptions.length != 0) {
            throw new InvalidClassException("No-arg constructor of class " + constructor.getDeclaringClass().getName() + " is throws exceptions " + Arrays.asList(exceptions));
        }
    }
}

