/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.icegem.serialization.codegen;

import com.googlecode.icegem.serialization.codegen.CodeGenUtils;
import com.googlecode.icegem.serialization.codegen.XClass;
import com.googlecode.icegem.serialization.codegen.XProperty;
import com.googlecode.icegem.serialization.codegen.impl.ToDataFieldProcessor;
import java.util.List;

public class MethodToDataProcessor {
    public String process(XClass element) {
        if (Enum.class.isAssignableFrom(element.getType())) {
            if (element.getType() == Enum.class) {
                throw new RuntimeException("Never here!");
            }
            return this.processEnum(element);
        }
        return this.processNotEnum(element);
    }

    private String processNotEnum(XClass xClass) {
        StringBuilder builder = new StringBuilder();
        List<XProperty> props = xClass.getOrderedProperties();
        String className = xClass.getType().getName();
        builder.append("public boolean toData(Object obj, java.io.DataOutput out) throws java.io.IOException {\n").append(CodeGenUtils.tab("try {\n")).append(CodeGenUtils.tab(2, "// check arg is of correct type\n")).append(CodeGenUtils.tab(2, "if (obj.getClass() != " + className + ".class) {return false;}\n"));
        builder.append(CodeGenUtils.tab(2, "// increment thread-local method-frame counter\n")).append(CodeGenUtils.tab(2, "if (com.googlecode.icegem.serialization.codegen.MethodFrameCounter.ENABLED) {\n")).append(CodeGenUtils.tab(3, "com.googlecode.icegem.serialization.codegen.MethodFrameCounter.enterFrame(\"" + className + "\");\n")).append(CodeGenUtils.tab(2, "}\n"));
        builder.append(CodeGenUtils.tab(2, "// convert to concrete type\n")).append(CodeGenUtils.tab(2, className)).append(" concrete = (").append(className).append(") obj;\n");
        builder.append("\n");
        byte versionHistoryLength = xClass.getVersionHistoryLength();
        byte header = (byte)(0 | versionHistoryLength);
        builder.append(CodeGenUtils.tab(2, "// write header version and version history lenght\n"));
        builder.append(CodeGenUtils.tab(2, "out.writeByte(" + header + ");\n"));
        byte beanVersion = xClass.getBeanVersion();
        builder.append(CodeGenUtils.tab(2, "// bean version\n")).append(CodeGenUtils.tab(2, "out.writeByte(" + beanVersion + ");\n")).append("\n");
        builder.append(CodeGenUtils.tab(2, "// write class model control hash codes\n"));
        builder.append(CodeGenUtils.tab(2, "VERSION_METADATA.writeAll(out);\n"));
        for (XProperty prop : props) {
            builder.append("\n");
            builder.append(CodeGenUtils.tab(2, "// this." + prop.getName() + " -> byte[]\n"));
            builder.append(CodeGenUtils.tab(2, new ToDataFieldProcessor().process(prop)));
        }
        builder.append("\n");
        builder.append(CodeGenUtils.tab(2, "return true;\n")).append(CodeGenUtils.tab("} finally {\n")).append(CodeGenUtils.tab(2, "if (com.googlecode.icegem.serialization.codegen.MethodFrameCounter.ENABLED) {\n")).append(CodeGenUtils.tab(3, "// decrement thread-local method-frame counter\n")).append(CodeGenUtils.tab(3, "com.googlecode.icegem.serialization.codegen.MethodFrameCounter.exitFrame(\"" + className + "\");\n")).append(CodeGenUtils.tab(2, "}\n")).append(CodeGenUtils.tab("}\n")).append("}\n");
        return builder.toString();
    }

    private String processEnum(XClass element) {
        StringBuilder builder = new StringBuilder();
        String className = element.getType().getName();
        builder.append("public boolean toData(Object obj, java.io.DataOutput out) throws java.io.IOException {\n").append(CodeGenUtils.tab("// check arg is of correct type\n")).append(CodeGenUtils.tab("if (obj.getClass() != " + className + ".class) {return false;}\n")).append(CodeGenUtils.tab("// convert to concrete type\n")).append(CodeGenUtils.tab(className)).append(" concrete = (").append(className).append(") obj;\n");
        builder.append(CodeGenUtils.tab("// write only 'name'\n"));
        builder.append(CodeGenUtils.tab("out.writeUTF(concrete.name());\n"));
        builder.append(CodeGenUtils.tab("return true;\n")).append("}\n");
        return builder.toString();
    }
}

