/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.icegem.serialization.codegen;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class VersionMap {
    private short[] hashCodes;
    private byte baseVersion;
    private String className;

    public VersionMap(String className, int baseVersion, int size) {
        this.className = className;
        this.baseVersion = (byte)baseVersion;
        this.hashCodes = new short[size];
    }

    public void put(byte version, short hash) {
        int offset = this.baseVersion - version;
        if (offset < 0 || offset >= this.hashCodes.length) {
            throw new IllegalArgumentException("Version " + version + " is not supposed to be stored");
        }
        this.hashCodes[offset] = hash;
    }

    public void validate(byte version, short hash) {
        int offset = this.baseVersion - version;
        if (offset >= 0 && offset < this.hashCodes.length && hash != this.hashCodes[offset]) {
            String message = String.format("Metadata of class %s version %s different in serializer and binary form. Check all properties have @SinceVersion notification and no property have been deleted or mutated", this.className, version);
            throw new ClassCastException(message);
        }
    }

    public void writeAll(DataOutput out) throws IOException {
        for (int i = 0; i < this.hashCodes.length; ++i) {
            out.writeShort(this.hashCodes[i]);
        }
    }

    public void readAndCheck(DataInput in, byte actualVersion, byte len) throws IOException {
        for (int i = 0; i < actualVersion; ++i) {
            short hashFromBinary = in.readShort();
            this.validate((byte)(actualVersion - i), hashFromBinary);
        }
    }
}

