/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.icegem.utils;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;

public class PropertiesHelper {
    private static final String KEY_VALUE_SEPARATOR = "=";
    private static final String PROPERTIES_SEPARATOR = ";";
    private Properties properties = new Properties();

    public PropertiesHelper(String filename) throws FileNotFoundException, IOException {
        this.properties.load(this.getClass().getResourceAsStream(filename));
    }

    public String getStringProperty(String key) {
        return (String)this.properties.get(key);
    }

    public String getStringProperty(String key, Object ... parameters) {
        String value = (String)this.properties.get(key);
        MessageFormat.format(value, parameters);
        return MessageFormat.format(value, parameters);
    }

    public int getIntProperty(String key) {
        String value = this.properties.getProperty(key);
        return Integer.parseInt(value);
    }

    public long getLongProperty(String key) {
        String value = this.properties.getProperty(key);
        return Long.parseLong(value);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public static String propertiesToString(Properties properties) {
        StringBuilder sb = new StringBuilder();
        Iterator<Object> it = properties.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            String value = (String)properties.get(key);
            sb.append(key).append(KEY_VALUE_SEPARATOR).append(value);
            if (!it.hasNext()) continue;
            sb.append(PROPERTIES_SEPARATOR);
        }
        return sb.toString();
    }

    public static Properties stringToProperties(String s) {
        String[] keyValues;
        Properties properties = new Properties();
        for (String keyValue : keyValues = s.split(PROPERTIES_SEPARATOR)) {
            String[] keyAndValue = keyValue.split(KEY_VALUE_SEPARATOR);
            properties.put(keyAndValue[0], keyAndValue[1]);
        }
        return properties;
    }

    public static Properties filterProperties(Properties properties, String prefix) {
        Properties result = new Properties();
        for (Object keyObject : properties.keySet()) {
            String key = (String)keyObject;
            String value = properties.getProperty(key);
            if (!key.startsWith(prefix)) continue;
            result.put(key, value);
        }
        return result;
    }

    public static String[] propertiesToVMOptions(Properties properties) {
        ArrayList<String> result = new ArrayList<String>();
        for (Object keyObject : properties.keySet()) {
            String key = (String)keyObject;
            String value = properties.getProperty(key);
            result.add("-D" + key + KEY_VALUE_SEPARATOR + value);
        }
        return result.toArray(new String[result.size()]);
    }
}

