/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.icegem.utils.function;

import com.gemstone.gemfire.admin.RegionNotFoundException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.ResultSender;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import java.io.Serializable;
import java.util.Set;

public class ClearPartitionedRegionFunction
extends FunctionAdapter {
    private static final String FUNCTION_ID = ClearPartitionedRegionFunction.class.getName();

    public void execute(FunctionContext functionContext) {
        ResultSender rs = functionContext.getResultSender();
        Serializable arg = functionContext.getArguments();
        if (!(arg instanceof String)) {
            rs.sendException((Throwable)new IllegalStateException("Function parameter must be instance of String.class"));
            return;
        }
        String regionName = (String)((Object)arg);
        Region region = CacheFactory.getAnyInstance().getRegion(regionName);
        if (region == null) {
            rs.sendException((Throwable)new RegionNotFoundException("Region '" + regionName + "' does not exist on this member"));
            return;
        }
        if (region.getAttributes().getDataPolicy().withPartitioning()) {
            Set keys = PartitionRegionHelper.getLocalPrimaryData((Region)region).keySet();
            for (Object key : keys) {
                region.destroy(key);
            }
        } else {
            region.clear();
        }
        rs.lastResult((Serializable)Boolean.valueOf(true));
    }

    public String getId() {
        return FUNCTION_ID;
    }
}

