package com.googlecode.icegem.serialization.codegen.impl.primitive;

import com.googlecode.icegem.serialization.codegen.XProperty;
import com.googlecode.icegem.serialization.codegen.impl.ToDataProcessor;

import static com.googlecode.icegem.serialization.codegen.CodeGenUtils.firstLetterToUpperCase;

/**
 * @author igolovach
 */

public class ToDataPrimitiveProcessor implements ToDataProcessor {
    private final String dataOutputMethod;

    public ToDataPrimitiveProcessor(String dataOutputMethod) {
        this.dataOutputMethod = dataOutputMethod;
    }

    public String process(XProperty field) {
        String fieldName = field.getName();
        if (field.isBoolean()) {
            return "out." + dataOutputMethod + "(concrete.is" + firstLetterToUpperCase(fieldName) + "());\n";
        }
        return "out." + dataOutputMethod + "(concrete.get" + firstLetterToUpperCase(fieldName) + "());\n";
    }
}
