/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.icegem.expiration;

import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.distributed.DistributedMember;
import java.io.Serializable;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DestroyedEntriesCountCollector
implements ResultCollector<Serializable, Serializable> {
    private Semaphore lock = new Semaphore(1);
    private long destroyedEntriesCount;

    public void addResult(DistributedMember member, Serializable value) {
        try {
            this.lock.acquire();
            if (value instanceof Long) {
                long partialCount = (Long)value;
                this.destroyedEntriesCount += partialCount;
            }
        }
        catch (InterruptedException e) {
            throw new FunctionException((Throwable)e);
        }
        finally {
            this.lock.release();
        }
    }

    public void clearResults() {
        try {
            this.lock.acquire();
            this.destroyedEntriesCount = 0L;
        }
        catch (InterruptedException e) {
            throw new FunctionException((Throwable)e);
        }
        finally {
            this.lock.release();
        }
    }

    public void endResults() {
    }

    public Serializable getResult() throws FunctionException {
        try {
            this.lock.acquire();
            Long l = this.destroyedEntriesCount;
            return l;
        }
        catch (InterruptedException e) {
            throw new FunctionException((Throwable)e);
        }
        finally {
            this.lock.release();
        }
    }

    public Serializable getResult(long timeout, TimeUnit timeUnit) throws FunctionException, InterruptedException {
        try {
            if (!this.lock.tryAcquire(timeout, timeUnit)) {
                throw new FunctionException("Timeout during the lock acquiring");
            }
            Long l = this.destroyedEntriesCount;
            return l;
        }
        catch (InterruptedException e) {
            throw new FunctionException((Throwable)e);
        }
        finally {
            this.lock.release();
        }
    }
}

