/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.icegem.serialization;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.googlecode.icegem.serialization.Configuration;
import com.googlecode.icegem.serialization.codegen.DataSerializerGenerator;
import com.googlecode.icegem.serialization.serializers.RegisteredDataSerializers;
import java.io.InvalidClassException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javassist.CannotCompileException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierarchyRegistry {
    private static Logger logger = LoggerFactory.getLogger(HierarchyRegistry.class);
    private static final Set<Class<?>> uniqueClass = new HashSet();

    public static synchronized void registerAll(ClassLoader classLoader, Class<?> ... classArray) throws InvalidClassException, CannotCompileException {
        HierarchyRegistry.registerAll(classLoader, Arrays.asList(classArray), null);
    }

    public static synchronized void registerAll(ClassLoader classLoader, List<Class<?>> classList) throws InvalidClassException, CannotCompileException {
        HierarchyRegistry.registerAll(classLoader, classList, null);
    }

    public static synchronized void registerAll(ClassLoader classLoader, List<Class<?>> classList, String outputDir) throws InvalidClassException, CannotCompileException {
        List<String> list = Arrays.asList("c");
        LinkedList classListToGenerate = new LinkedList();
        for (Class<?> clazz : classList) {
            if (!uniqueClass.contains(clazz)) {
                classListToGenerate.add(clazz);
                uniqueClass.add(clazz);
                continue;
            }
            logger.debug("Duplicate registration of class {}. Skipping...", clazz);
        }
        List<Class<?>> serializerClassList = DataSerializerGenerator.generateDataSerializerClasses(classLoader, classListToGenerate, outputDir);
        for (Class<?> clazz : serializerClassList) {
            InternalDataSerializer.register(clazz, (boolean)Configuration.get().isDeserializerRegistrationDistributed());
        }
        HierarchyRegistry.registerDataSerializers();
    }

    public static void registerDataSerializers() {
        for (Class<?> clazz : RegisteredDataSerializers.getDataSerializers()) {
            DataSerializer.register(clazz);
        }
    }
}

