/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.icegem.serialization.codegen;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodFrameCounter
extends ThreadLocal<AtomicInteger> {
    public static final String SYSTEM_PROPERTY_NAME = "icegem.serialization.trace.methodframes";
    public static boolean ENABLED = Boolean.getBoolean("icegem.serialization.trace.methodframes");
    public static final int MAX_STACK_DEPTH = 256;
    public static final String STACK_OVERFLOW_MSG = "Too deep method frame stack - 256. Perhaps cyclic references in serialized object have been found.";
    private static final ThreadLocal<AtomicInteger> local = new ThreadLocal<AtomicInteger>(){

        @Override
        protected synchronized AtomicInteger initialValue() {
            return new AtomicInteger(0);
        }
    };
    private static final ThreadLocal<List<String>> classNames = new ThreadLocal<List<String>>(){

        @Override
        protected synchronized List<String> initialValue() {
            return new ArrayList<String>();
        }
    };

    public static void enterFrame(String className) {
        int counter = local.get().incrementAndGet();
        classNames.get().add(className);
        if (counter == 256) {
            throw new RuntimeException(STACK_OVERFLOW_MSG + MethodFrameCounter.getClassNames());
        }
    }

    public static void exitFrame(String className) {
        int counter = local.get().decrementAndGet();
        if (counter < 0) {
            String errorMessage = "Method frame counter is less then 0. Some programming error: count(exitFrame) > count(enterFrame)." + MethodFrameCounter.getClassNames();
            MethodFrameCounter.clearCounter();
            throw new RuntimeException(errorMessage);
        }
        String frameToExit = classNames.get().remove(classNames.get().size() - 1);
        if (!className.equals(frameToExit)) {
            throw new RuntimeException("Method frame counter try to exit from the class '" + className + "' but must exit from the class '" + frameToExit + "' first." + MethodFrameCounter.getClassNames());
        }
    }

    private static void clearCounter() {
        local.get().set(0);
        classNames.get().clear();
    }

    private static String getClassNames() {
        StringBuilder result = new StringBuilder("\nMethod frame counter enter to the following classes:\n");
        for (String className : classNames.get()) {
            result.append(className).append("\n");
        }
        return result.toString();
    }
}

