/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.icegem.serialization.codegen;

import com.googlecode.icegem.serialization.AutoSerializable;
import com.googlecode.icegem.serialization.BeanVersion;
import com.googlecode.icegem.serialization.codegen.Introspector;
import com.googlecode.icegem.serialization.codegen.XProperty;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XClass {
    private final Class<?> clazz;
    private byte beanVersion;

    public XClass(Class<?> clazz) {
        this.clazz = clazz;
        BeanVersion annotation = this.getType().getAnnotation(BeanVersion.class);
        if (annotation != null) {
            this.beanVersion = annotation.value();
            if (this.beanVersion < 1) {
                throw new RuntimeException("Value of annotation @BeanVersion must be positive, current value = " + this.beanVersion + " (class '" + clazz + "')");
            }
        } else {
            throw new RuntimeException("Class must be annotated with @BeanVersion: " + this.getType().getCanonicalName());
        }
    }

    public Class<?> getType() {
        return this.clazz;
    }

    public List<XProperty> getOrderedProperties() {
        List<XProperty> result = Introspector.getProperties(this.clazz);
        Collections.sort(result, new XProperty.NaturalOrder());
        return result;
    }

    public byte getBeanVersion() {
        return this.beanVersion;
    }

    public byte getVersionHistoryLength() {
        AutoSerializable annotation = this.getType().getAnnotation(AutoSerializable.class);
        byte versionHistoryLength = annotation.versionHistoryLength();
        if (versionHistoryLength < 1) {
            throw new IllegalArgumentException("Version history length of annotation @AutoSerializable must be positive, current value = " + versionHistoryLength + " (class '" + this.clazz.getCanonicalName() + "')");
        }
        if ((versionHistoryLength = (byte)(versionHistoryLength + 1)) > this.getBeanVersion()) {
            versionHistoryLength = this.getBeanVersion();
        }
        return versionHistoryLength;
    }

    public String getName() {
        return this.clazz.getName();
    }

    public short getVersionModelHashCode(int version) {
        List<XProperty> classFields = this.getOrderedProperties();
        StringBuilder builder = new StringBuilder();
        for (XProperty field : classFields) {
            if (version != -1 && version < field.getPropertyVersion()) continue;
            builder.append(field.getType()).append(field.getName());
        }
        int hashCode = builder.toString().hashCode();
        return (short)(hashCode & 0xFFFF ^ (hashCode & 0xFFFF0000) >> 16);
    }
}

