/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.icegem.serialization.codegen.impl;

import com.googlecode.icegem.serialization.codegen.XProperty;
import com.googlecode.icegem.serialization.codegen.impl.FromDataFieldResolveClassByGemFireProcessor;
import com.googlecode.icegem.serialization.codegen.impl.FromDataProcessor;
import com.googlecode.icegem.serialization.codegen.impl.primitive.FromDataPrimitiveProcessor;
import com.googlecode.icegem.serialization.codegen.impl.primitivearray.FromDataFieldPrimitiveArrayProcessor;
import com.googlecode.icegem.serialization.codegen.impl.system.FromDataFieldCalendarProcessor;
import com.googlecode.icegem.serialization.codegen.impl.system.FromDataFieldConcreteEnumProcessor;
import com.googlecode.icegem.serialization.codegen.impl.system.FromDataFieldDateProcessor;
import com.googlecode.icegem.serialization.codegen.impl.system.FromDataFieldStringProcessor;
import com.googlecode.icegem.serialization.codegen.impl.wrapper.FromDataFieldWrapperProcessor;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class FromDataFieldProcessor {
    private Map<Class<?>, FromDataProcessor> map = new HashMap();

    public FromDataFieldProcessor() {
        this.map.put(Boolean.TYPE, new FromDataPrimitiveProcessor("readBoolean"));
        this.map.put(Byte.TYPE, new FromDataPrimitiveProcessor("readByte"));
        this.map.put(Character.TYPE, new FromDataPrimitiveProcessor("readChar"));
        this.map.put(Short.TYPE, new FromDataPrimitiveProcessor("readShort"));
        this.map.put(Integer.TYPE, new FromDataPrimitiveProcessor("readInt"));
        this.map.put(Long.TYPE, new FromDataPrimitiveProcessor("readLong"));
        this.map.put(Float.TYPE, new FromDataPrimitiveProcessor("readFloat"));
        this.map.put(Double.TYPE, new FromDataPrimitiveProcessor("readDouble"));
        this.map.put(Boolean.class, new FromDataFieldWrapperProcessor("Boolean", "readBoolean"));
        this.map.put(Byte.class, new FromDataFieldWrapperProcessor("Byte", "readByte"));
        this.map.put(Character.class, new FromDataFieldWrapperProcessor("Character", "readChar"));
        this.map.put(Short.class, new FromDataFieldWrapperProcessor("Short", "readShort"));
        this.map.put(Integer.class, new FromDataFieldWrapperProcessor("Integer", "readInt"));
        this.map.put(Long.class, new FromDataFieldWrapperProcessor("Long", "readLong"));
        this.map.put(Float.class, new FromDataFieldWrapperProcessor("Float", "readFloat"));
        this.map.put(Double.class, new FromDataFieldWrapperProcessor("Double", "readDouble"));
        this.map.put(boolean[].class, new FromDataFieldPrimitiveArrayProcessor("readBooleanArray"));
        this.map.put(byte[].class, new FromDataFieldPrimitiveArrayProcessor("readByteArray"));
        this.map.put(short[].class, new FromDataFieldPrimitiveArrayProcessor("readShortArray"));
        this.map.put(char[].class, new FromDataFieldPrimitiveArrayProcessor("readCharArray"));
        this.map.put(int[].class, new FromDataFieldPrimitiveArrayProcessor("readIntArray"));
        this.map.put(long[].class, new FromDataFieldPrimitiveArrayProcessor("readLongArray"));
        this.map.put(float[].class, new FromDataFieldPrimitiveArrayProcessor("readFloatArray"));
        this.map.put(double[].class, new FromDataFieldPrimitiveArrayProcessor("readDoubleArray"));
        this.map.put(String.class, new FromDataFieldStringProcessor());
        this.map.put(Date.class, new FromDataFieldDateProcessor());
        this.map.put(Calendar.class, new FromDataFieldCalendarProcessor());
    }

    public String process(XProperty field) {
        Class<?> fieldClass = field.getType();
        if (this.map.get(fieldClass) != null) {
            return this.map.get(fieldClass).process(field);
        }
        if (Enum.class.isAssignableFrom(fieldClass) && fieldClass != Enum.class) {
            return new FromDataFieldConcreteEnumProcessor().process(field);
        }
        return new FromDataFieldResolveClassByGemFireProcessor().process(field);
    }
}

