/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.icegem.serialization.codegen.impl;

import com.googlecode.icegem.serialization.codegen.XProperty;
import com.googlecode.icegem.serialization.codegen.impl.ToDataFieldResolveClassByGemFireProcessor;
import com.googlecode.icegem.serialization.codegen.impl.ToDataProcessor;
import com.googlecode.icegem.serialization.codegen.impl.primitive.ToDataPrimitiveProcessor;
import com.googlecode.icegem.serialization.codegen.impl.primitivearray.ToDataFieldPrimitiveArrayProcessor;
import com.googlecode.icegem.serialization.codegen.impl.system.ToDataFieldCalendarProcessor;
import com.googlecode.icegem.serialization.codegen.impl.system.ToDataFieldConcreteEnumProcessor;
import com.googlecode.icegem.serialization.codegen.impl.system.ToDataFieldDateProcessor;
import com.googlecode.icegem.serialization.codegen.impl.system.ToDataFieldStringProcessor;
import com.googlecode.icegem.serialization.codegen.impl.wrapper.ToDataFieldWrapperProcessor;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class ToDataFieldProcessor {
    public Map<Class<?>, ToDataProcessor> map = new HashMap();

    public ToDataFieldProcessor() {
        this.map.put(Boolean.TYPE, new ToDataPrimitiveProcessor("writeBoolean"));
        this.map.put(Byte.TYPE, new ToDataPrimitiveProcessor("writeByte"));
        this.map.put(Character.TYPE, new ToDataPrimitiveProcessor("writeChar"));
        this.map.put(Short.TYPE, new ToDataPrimitiveProcessor("writeShort"));
        this.map.put(Integer.TYPE, new ToDataPrimitiveProcessor("writeInt"));
        this.map.put(Long.TYPE, new ToDataPrimitiveProcessor("writeLong"));
        this.map.put(Float.TYPE, new ToDataPrimitiveProcessor("writeFloat"));
        this.map.put(Double.TYPE, new ToDataPrimitiveProcessor("writeDouble"));
        this.map.put(Boolean.class, new ToDataFieldWrapperProcessor("booleanValue", "writeBoolean"));
        this.map.put(Byte.class, new ToDataFieldWrapperProcessor("byteValue", "writeByte"));
        this.map.put(Character.class, new ToDataFieldWrapperProcessor("charValue", "writeChar"));
        this.map.put(Short.class, new ToDataFieldWrapperProcessor("shortValue", "writeShort"));
        this.map.put(Integer.class, new ToDataFieldWrapperProcessor("intValue", "writeInt"));
        this.map.put(Long.class, new ToDataFieldWrapperProcessor("longValue", "writeLong"));
        this.map.put(Float.class, new ToDataFieldWrapperProcessor("floatValue", "writeFloat"));
        this.map.put(Double.class, new ToDataFieldWrapperProcessor("doubleValue", "writeDouble"));
        this.map.put(boolean[].class, new ToDataFieldPrimitiveArrayProcessor("writeBooleanArray"));
        this.map.put(byte[].class, new ToDataFieldPrimitiveArrayProcessor("writeByteArray"));
        this.map.put(short[].class, new ToDataFieldPrimitiveArrayProcessor("writeShortArray"));
        this.map.put(char[].class, new ToDataFieldPrimitiveArrayProcessor("writeCharArray"));
        this.map.put(int[].class, new ToDataFieldPrimitiveArrayProcessor("writeIntArray"));
        this.map.put(long[].class, new ToDataFieldPrimitiveArrayProcessor("writeLongArray"));
        this.map.put(float[].class, new ToDataFieldPrimitiveArrayProcessor("writeFloatArray"));
        this.map.put(double[].class, new ToDataFieldPrimitiveArrayProcessor("writeDoubleArray"));
        this.map.put(String.class, new ToDataFieldStringProcessor());
        this.map.put(Date.class, new ToDataFieldDateProcessor());
        this.map.put(Calendar.class, new ToDataFieldCalendarProcessor());
    }

    public String process(XProperty field) {
        Class<?> fieldClass = field.getType();
        if (this.map.get(fieldClass) != null) {
            return this.map.get(fieldClass).process(field);
        }
        if (Enum.class.isAssignableFrom(fieldClass) && fieldClass != Enum.class) {
            return new ToDataFieldConcreteEnumProcessor().process(field);
        }
        return new ToDataFieldResolveClassByGemFireProcessor().process(field);
    }
}

