/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.icegem.serialization.spring;

import com.googlecode.icegem.serialization.AutoSerializable;
import com.googlecode.icegem.serialization.HierarchyRegistry;
import java.io.InvalidClassException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javassist.CannotCompileException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoSerializableRegistrarBean
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger((String)AutoSerializableRegistrarBean.class.getName());
    private List<Class<?>> registeredClasses = new ArrayList();
    private List<String> scanPackages = new ArrayList<String>();

    public void setRegisteredClasses(List<Class<?>> registeredClasses) {
        this.registeredClasses = registeredClasses;
    }

    public void setScanPackages(List<String> scanPackages) {
        this.scanPackages = scanPackages;
    }

    public void afterPropertiesSet() throws Exception {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        this.registerClasses(classLoader);
    }

    private void registerClasses(ClassLoader classLoader) throws ClassNotFoundException {
        String msg;
        ArrayList toRegister = new ArrayList();
        for (String pack : this.scanPackages) {
            logger.debug("Scan {}.* for @AutoSerializable classes", (Object)pack);
            ClassPathScanningCandidateComponentProvider ppp = new ClassPathScanningCandidateComponentProvider(false);
            ppp.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(AutoSerializable.class));
            Set candidateComponents = ppp.findCandidateComponents(pack);
            for (BeanDefinition beanDefinition : candidateComponents) {
                String className = beanDefinition.getBeanClassName();
                Class<?> clazz = Class.forName(className);
                toRegister.add(clazz);
            }
        }
        toRegister.addAll(this.registeredClasses);
        logger.info("All classes that will be registered in GemFire: " + toRegister);
        try {
            HierarchyRegistry.registerAll(classLoader, toRegister);
        }
        catch (InvalidClassException e) {
            msg = "Some class from list " + toRegister + " is nor serializable. Cause: " + e.getMessage();
            throw new IllegalArgumentException(msg, e);
        }
        catch (CannotCompileException e) {
            msg = "Can't compile DataSerializer classes for some classes from list " + toRegister + ". Cause: " + e.getMessage();
            throw new IllegalArgumentException(msg, e);
        }
    }
}

