/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.icegem.utils;

import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.distributed.DistributedMember;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegionSizeResultCollector
implements ResultCollector<Integer, Integer> {
    private int size;
    private final Object mux = new Object();
    private boolean done;

    public void addResult(DistributedMember memberID, Integer singleRes) {
        if (singleRes != null) {
            this.size += singleRes.intValue();
        }
    }

    public void clearResults() {
        this.size = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endResults() {
        Object object = this.mux;
        synchronized (object) {
            this.done = true;
            this.mux.notifyAll();
        }
    }

    public Integer getResult() throws FunctionException {
        try {
            return this.getResult(0L, null);
        }
        catch (InterruptedException e) {
            throw new FunctionException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getResult(long timeout, TimeUnit unit) throws FunctionException, InterruptedException {
        if (timeout > 0L && unit == null) {
            throw new IllegalArgumentException("Parameter unit cannot be nul if timeout > 0");
        }
        Object object = this.mux;
        synchronized (object) {
            while (!this.done) {
                if (timeout > 0L) {
                    unit.timedWait(this.mux, timeout);
                    continue;
                }
                this.mux.wait();
            }
        }
        return this.size;
    }
}

