/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.icegem.query.bucketoriented;

import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.RegionFunctionContext;
import com.gemstone.gemfire.cache.execute.ResultSender;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.internal.DefaultQuery;
import com.gemstone.gemfire.internal.cache.LocalDataSet;
import com.googlecode.icegem.query.bucketoriented.BucketOrientedQueryFunctionArgument;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BucketOrientedQueryFunction
extends FunctionAdapter {
    private static final String FUNCTION_ID = BucketOrientedQueryFunction.class.getName();
    private static final long serialVersionUID = -8818891792083706794L;
    private Logger logger = LoggerFactory.getLogger(BucketOrientedQueryFunction.class);

    public void execute(FunctionContext functionContext) {
        ResultSender resultSender = functionContext.getResultSender();
        RegionFunctionContext regionFunctionContext = (RegionFunctionContext)functionContext;
        if (functionContext.getArguments() == null) {
            this.handleException((Throwable)new FunctionException("You must specify function argument for query execution."), (ResultSender<Serializable>)resultSender, null);
            return;
        }
        if (!(functionContext.getArguments() instanceof BucketOrientedQueryFunctionArgument)) {
            this.handleException((Throwable)new FunctionException("Function arguments must be of type " + BucketOrientedQueryFunctionArgument.class.getName() + "."), (ResultSender<Serializable>)resultSender, null);
            return;
        }
        BucketOrientedQueryFunctionArgument argument = (BucketOrientedQueryFunctionArgument)functionContext.getArguments();
        LocalDataSet localData = (LocalDataSet)PartitionRegionHelper.getLocalDataForContext((RegionFunctionContext)regionFunctionContext);
        QueryService queryService = localData.getCache().getQueryService();
        String queryStr = argument.getQueryString();
        try {
            Query query = queryService.newQuery(queryStr);
            SelectResults result = (SelectResults)localData.executeQuery((DefaultQuery)query, argument.getQueryParameters(), localData.getBucketSet());
            resultSender.lastResult((Serializable)((Object)this.formatResults(result)));
        }
        catch (Exception e) {
            this.handleException(e, (ResultSender<Serializable>)resultSender, queryStr);
        }
    }

    public String getId() {
        return FUNCTION_ID;
    }

    public boolean optimizeForWrite() {
        return false;
    }

    private void handleException(Throwable e, ResultSender<Serializable> resultSender, String queryString) {
        this.logger.error("Failed to execute bucket oriented query" + (queryString != null ? ": " + queryString : "."), e);
        resultSender.sendException((Throwable)new FunctionException(e.getMessage()));
    }

    private List<Object> formatResults(SelectResults<?> selectResults) {
        ArrayList<Object> results = new ArrayList<Object>(selectResults.size() + 1);
        results.addAll(selectResults.asList());
        results.add(selectResults.getCollectionType().getElementType());
        return results;
    }
}

