/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.icegem.query.pagination;

import com.gemstone.gemfire.DataSerializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;

public class PageKey
implements Serializable {
    private String queryString;
    private Object[] queryParameters;
    private int queryLimit;
    private int pageNumber;
    private int pageSize;

    public PageKey(String queryString, Object[] queryParameters, int queryLimit, int pageSize, int pageNumber) {
        this.queryString = queryString;
        this.queryParameters = queryParameters;
        this.queryLimit = queryLimit;
        this.pageNumber = pageNumber;
        this.pageSize = pageSize;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PageKey other = (PageKey)obj;
        if (this.pageNumber != other.pageNumber) {
            return false;
        }
        if (this.pageSize != other.pageSize) {
            return false;
        }
        if (this.queryLimit != other.queryLimit) {
            return false;
        }
        if (!Arrays.equals(this.queryParameters, other.queryParameters)) {
            return false;
        }
        return !(this.queryString == null ? other.queryString != null : !this.queryString.equals(other.queryString));
    }

    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.pageNumber = in.readInt();
        this.pageSize = in.readInt();
        this.queryLimit = in.readInt();
        this.queryString = DataSerializer.readString((DataInput)in);
        this.queryParameters = DataSerializer.readObjectArray((DataInput)in);
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getQueryLimit() {
        return this.queryLimit;
    }

    public Object[] getQueryParameters() {
        return this.queryParameters;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.pageNumber;
        result = 31 * result + this.pageSize;
        result = 31 * result + this.queryLimit;
        result = 31 * result + Arrays.hashCode(this.queryParameters);
        result = 31 * result + (this.queryString == null ? 0 : this.queryString.hashCode());
        return result;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setQueryLimit(int queryLimit) {
        this.queryLimit = queryLimit;
    }

    public void setQueryParameters(Object[] queryParameters) {
        this.queryParameters = queryParameters;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public void toData(DataOutput out) throws IOException {
        out.writeInt(this.pageNumber);
        out.writeInt(this.pageSize);
        out.writeInt(this.queryLimit);
        DataSerializer.writeString((String)this.queryString, (DataOutput)out);
        DataSerializer.writeObjectArray((Object[])this.queryParameters, (DataOutput)out);
    }

    public String toString() {
        return "PageKey [queryString=" + this.queryString + ", queryParameters=" + Arrays.toString(this.queryParameters) + ", queryLimit=" + this.queryLimit + ", pageSize=" + this.pageSize + ", pageNumber=" + this.pageNumber + "]";
    }
}

