/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.icegem.query.pagination;

import com.gemstone.bp.edu.emory.mathcs.backport.java.util.Collections;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionService;
import com.gemstone.gemfire.cache.query.FunctionDomainException;
import com.gemstone.gemfire.cache.query.NameResolutionException;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.QueryException;
import com.gemstone.gemfire.cache.query.QueryInvocationTargetException;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.RegionNotFoundException;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.Struct;
import com.gemstone.gemfire.cache.query.TypeMismatchException;
import com.googlecode.icegem.query.pagination.PageKey;
import com.googlecode.icegem.utils.CacheUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PaginatedQuery<V> {
    public static final int DEFAULT_PAGE_SIZE = 20;
    public static final int DEFAULT_QUERY_LIMIT = 1000;
    public static final int PAGE_NUMBER_FOR_GENERAL_INFO = -1;
    public static final String PAGINATED_QUERY_INFO_REGION_NAME = "paginated_query_info";
    private static final Logger logger = LoggerFactory.getLogger(PaginatedQuery.class);
    private QueryService queryService;
    private Region<Object, V> queryRegion;
    private Region<PageKey, List<Object>> paginatedQueryInfoRegion;
    private int pageSize;
    private String queryString;
    private Object[] queryParams;
    private int queryLimit;
    private boolean infoLoaded;
    private boolean limitExceeded;
    private int totalNumberOfEntries;

    public PaginatedQuery(QueryService queryService, int queryLimit, Region<Object, V> region, String queryString) throws RegionNotFoundException {
        this(queryService, queryLimit, region, queryString, 20);
    }

    public PaginatedQuery(QueryService queryService, int queryLimit, Region<Object, V> region, String queryString, int pageSize) throws RegionNotFoundException {
        this(queryService, queryLimit, region, queryString, new Object[0], pageSize);
    }

    public PaginatedQuery(QueryService queryService, int queryLimit, Region<Object, V> region, String queryString, Object[] queryParameters) throws RegionNotFoundException {
        this(queryService, queryLimit, region, queryString, queryParameters, 20);
    }

    public PaginatedQuery(QueryService queryService, int queryLimit, Region<Object, V> region, String queryString, Object[] queryParameters, int pageSize) throws RegionNotFoundException {
        this.queryService = queryService;
        this.queryRegion = region;
        if (this.queryRegion == null) {
            throw new NullPointerException("Query region have to be provided");
        }
        RegionService regionService = this.queryRegion.getRegionService();
        this.paginatedQueryInfoRegion = regionService.getRegion(PAGINATED_QUERY_INFO_REGION_NAME);
        if (this.paginatedQueryInfoRegion == null) {
            RegionNotFoundException e = new RegionNotFoundException("Help region [paginated_query_info] for storing information about paginated queries has not been found");
            logger.warn(e.getMessage());
            throw e;
        }
        if (pageSize < 5) {
            throw new IllegalArgumentException("Page size must be greater than 4");
        }
        this.pageSize = pageSize;
        if (queryLimit < 1) {
            throw new IllegalArgumentException("Query limit must be positive");
        }
        this.queryLimit = queryLimit;
        this.queryString = CacheUtils.addQueryLimit(queryString, this.queryLimit);
        this.queryParams = queryParameters;
    }

    public PaginatedQuery(QueryService queryService, Region<Object, V> region, String queryString) throws RegionNotFoundException {
        this(queryService, 1000, region, queryString, 20);
    }

    public PaginatedQuery(QueryService queryService, Region<Object, V> region, String queryString, int pageSize) throws RegionNotFoundException {
        this(queryService, 1000, region, queryString, new Object[0], pageSize);
    }

    public PaginatedQuery(QueryService queryService, Region<Object, V> region, String queryString, Object[] queryParameters) throws RegionNotFoundException {
        this(queryService, 1000, region, queryString, queryParameters, 20);
    }

    public PaginatedQuery(QueryService queryService, Region<Object, V> region, String queryString, Object[] queryParameters, int pageSize) throws RegionNotFoundException {
        this(queryService, 1000, region, queryString, queryParameters, pageSize);
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getTotalNumberOfEntries() throws QueryException {
        this.prepareResultData(false);
        return this.totalNumberOfEntries;
    }

    public int getTotalNumberOfPages() throws QueryException {
        this.prepareResultData(false);
        if (this.isEmpty()) {
            return 1;
        }
        int total = this.totalNumberOfEntries / this.pageSize;
        if (this.totalNumberOfEntries % this.pageSize > 0) {
            ++total;
        }
        return total;
    }

    public boolean isLimitExceeded() throws QueryException {
        this.prepareResultData(false);
        return this.limitExceeded;
    }

    public List<V> page(int pageNumber) throws QueryException {
        List pageKeys = null;
        boolean firstTry = true;
        while (pageKeys == null) {
            this.prepareResultData(!firstTry);
            if (!this.pageExists(pageNumber)) {
                throw new IndexOutOfBoundsException("The page " + pageNumber + "does not exists. " + this.getTotalNumberOfPages() + " pages available.");
            }
            PageKey pageKey = this.newKey(pageNumber);
            pageKeys = (List)this.paginatedQueryInfoRegion.get((Object)pageKey);
            if (pageKeys != null || !firstTry) break;
            firstTry = false;
        }
        if (pageKeys != null) {
            return this.getValues(pageKeys);
        }
        throw new RuntimeException("Unable to load keys from cache. Too aggressive expiration policy?");
    }

    public boolean pageExists(int pageNumber) throws QueryException {
        return pageNumber == 1 || pageNumber >= 1 && pageNumber <= this.getTotalNumberOfPages();
    }

    protected void storePage(int pageNumber, List<Object> page) {
        PageKey pageKey = this.newKey(pageNumber);
        this.paginatedQueryInfoRegion.put((Object)pageKey, page);
    }

    private List<Object> extractKeys(SelectResults<Object> results) {
        ArrayList<Object> keys = new ArrayList(results.size());
        if (results.getCollectionType().getElementType().isStructType()) {
            for (Object result : results) {
                Object key;
                try {
                    key = ((Struct)result).get("key");
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException(e.getMessage() + " (hint: maybe you forgot to include entry key into query projection list)");
                }
                keys.add(key);
            }
        } else {
            keys = results.asList();
        }
        return keys;
    }

    private List<V> getValues(List<Object> entriesKeysForPage) {
        if (entriesKeysForPage.isEmpty()) {
            return Collections.emptyList();
        }
        Map entriesMap = this.queryRegion.getAll(entriesKeysForPage);
        ArrayList entries = new ArrayList(entriesKeysForPage.size());
        for (Object key : entriesKeysForPage) {
            entries.add(entriesMap.get(key));
        }
        return entries;
    }

    private void handleException(Exception e) throws QueryException {
        throw new QueryException("Exception has been thrown during query execution. Cause exception message: " + e.getMessage(), (Throwable)e);
    }

    private boolean isEmpty() {
        return this.totalNumberOfEntries == 0;
    }

    private PageKey newKey(int pageNumber) {
        return new PageKey(this.queryString, this.queryParams, this.queryLimit, this.pageSize, pageNumber);
    }

    private void prepareResultData(boolean force) throws QueryException {
        if (this.infoLoaded && !force) {
            return;
        }
        PageKey pageKey = this.newKey(-1);
        List<Object> queryInfo = null;
        if (!force) {
            queryInfo = (List<Object>)this.paginatedQueryInfoRegion.get((Object)pageKey);
        }
        if (queryInfo == null) {
            Query query = this.queryService.newQuery(this.queryString);
            SelectResults results = null;
            try {
                results = (SelectResults)query.execute(pageKey.getQueryParameters());
            }
            catch (FunctionDomainException e) {
                this.handleException((Exception)((Object)e));
            }
            catch (TypeMismatchException e) {
                this.handleException((Exception)((Object)e));
            }
            catch (NameResolutionException e) {
                this.handleException((Exception)((Object)e));
            }
            catch (QueryInvocationTargetException e) {
                this.handleException((Exception)((Object)e));
            }
            if (results.size() > this.queryLimit) {
                this.limitExceeded = true;
                this.totalNumberOfEntries = this.queryLimit;
                String msg = "Size of query results has exceeded limit (" + this.queryLimit + "). Truncated.";
                logger.warn(msg);
            } else {
                this.limitExceeded = false;
                this.totalNumberOfEntries = results.size();
            }
            queryInfo = Arrays.asList(results.size(), this.limitExceeded);
            this.storePage(-1, queryInfo);
            List<Object> keys = this.extractKeys((SelectResults<Object>)results);
            this.storeResults(keys);
        } else {
            this.totalNumberOfEntries = (Integer)queryInfo.get(0);
            this.limitExceeded = (Boolean)queryInfo.get(1);
        }
        this.infoLoaded = true;
    }

    private void storeResults(List<Object> resultKeys) {
        if (resultKeys.size() > this.queryLimit) {
            resultKeys = resultKeys.subList(0, this.queryLimit);
        }
        int keyNumber = 0;
        int pageNumber = 0;
        ArrayList<Object> page = new ArrayList<Object>();
        for (Object key : resultKeys) {
            if (keyNumber % this.getPageSize() == 0 && keyNumber != 0) {
                this.storePage(++pageNumber, page);
                page.clear();
            }
            page.add(key);
            ++keyNumber;
        }
        if (page.size() > 0 || pageNumber == 0) {
            this.storePage(++pageNumber, page);
        }
    }
}

